#!/usr/bin/env ruby
require("gsl")

N = 10000
MAX = 8
rng = Rng.new(2)

data = Ran.gaussian(rng, 1.5, N) + 2
h = Histogram.alloc(100, [-MAX, MAX])
h.increment(data)

sigma, mean, height, = h.fit_gaussian

x = Vector.linspace(-MAX, MAX, 100)
y = height*Ran::gaussian_pdf(x-mean, sigma)
GSL::graph(h, [x, y], "-T X -C -g 3")
