# Configure macro for Libnc-dap
# Patrice Dumas 2005 based on freetype2.m4 from Marcelo Magallon 2001-10-26, 
# based on gtk.m4 by Owen Taylor

# AC_CHECK_LIBNC_DAP([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap and define NC_DAP_CFLAGS and NC_DAP_LIBS.
# Check that the version is above MINIMUM-VERSION 

AC_DEFUN([AC_CHECK_LIBNC_DAP],
[
  AC_PATH_PROG([NC_DAP_CONFIG], [ncdap-config], [no])
  ncdap_min_version=m4_if([$1], [], [3.5.0], [$1])
  AC_MSG_CHECKING([for libnc-dap version >= $ncdap_min_version])
  ncdap_no=""
  if test "$NC_DAP_CONFIG" = "no" ; then
     ncdap_no=yes
  else
     ncdap_config_major_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\1/'`
     ncdap_config_minor_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\2/'`
     ncdap_config_micro_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\2/'`
     ncdap_min_major_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
     ncdap_min_minor_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
     ncdap_min_micro_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

     ncdap_config_is_lt=""
     if test $ncdap_config_major_version -lt $ncdap_min_major_version ; then
       ncdap_config_is_lt=yes
     else
       if test $ncdap_config_major_version -eq $ncdap_min_major_version ; then
         if test $ncdap_config_minor_version -lt $ncdap_min_minor_version ; then
           ncdap_config_is_lt=yes
         else
           if test $ncdap_config_minor_version -eq $ncdap_min_minor_version ; then
             if test $ncdap_config_micro_version -lt $ncdap_min_micro_version ; then
               ncdap_config_is_lt=yes
             fi
           fi
         fi
       fi
     fi
     if test x$ncdap_config_is_lt = xyes ; then
       ncdap_no=yes
     else
       NC_DAP_LIBS="`$NC_DAP_CONFIG --libs`"
       NC_DAP_CFLAGS="`$NC_DAP_CONFIG --cflags`"
     fi
   fi
   if test x$ncdap_no = x ; then
     AC_MSG_RESULT([yes])
     m4_if([$2], [], [:], [$2])
   else
     AC_MSG_RESULT([no])
     if test "$NC_DAP_CONFIG" = "no" ; then
     AC_MSG_NOTICE([The ncdap-config script could not be found.])
     else
       if test x$ncdap_config_is_lt = xyes ; then
         AC_MSG_NOTICE([the installed libnc-dap library is too old.])
       fi
     fi
     NC_DAP_LIBS=""
     NC_DAP_CFLAGS=""
     m4_if([$3], [], [:], [$3])
     
   fi
   AC_SUBST([NC_DAP_CFLAGS])
   AC_SUBST([NC_DAP_LIBS])
]) 


# AC_FC_CHECK_LIBNC_DAP([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap and define NC_DAP_FFLAGS and NC_DAP_FLIBS with flags
# for fortran.
# Check that the version is above MINIMUM-VERSION 

AC_DEFUN([AC_FC_CHECK_LIBNC_DAP],
[
  libnc_fc_dap_ok="no"
  AC_CHECK_LIBNC_DAP([$1],[libnc_fc_dap_ok="yes"],[libnc_fc_dap_ok="no"])
  if test $libnc_fc_dap_ok = "yes"; then
     NC_DAP_FLIBS="`$NC_DAP_CONFIG --flibs`"
     NC_DAP_FFLAGS="$NC_DAP_CFLAGS"
     m4_if([$2], [], [:], [$2])
  else
     m4_if([$3], [], [:], [$3])
     NC_DAP_FLIBS=""
     NC_DAP_FFLAGS=""
  fi
  AC_SUBST([NC_DAP_FFLAGS])
  AC_SUBST([NC_DAP_FLIBS])
])


# AC_CHECK_NC_DODS([ ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap or older versions. Define NC_DAP_CFLAGS and NC_DAP_LIBS.
# use AC_CHECK_DODS if the flags cannot be found easily

AC_DEFUN([AC_CHECK_NC_DODS],
[
  ac_ncdods_ok='no'
  AC_CHECK_LIBNC_DAP([],[ac_ncdods_ok='yes'],[ac_ncdods_ok='no'])
  if test "z$ac_ncdods_ok" = "zno" ; then
     AC_PATH_PROG([OPENNC_DAP_CONFIG], [opendap-config], [no])
     AC_MSG_CHECKING([for libnc-dap with opendap-config])
     if test "$OPENNC_DAP_CONFIG" = "no" ; then
       ac_ncdods_ok='no'
       AC_MSG_RESULT([no])
     else
       NC_DAP_LIBS="`$OPENNC_DAP_CONFIG --libs-nc`"
       NC_DAP_CFLAGS="`$OPENNC_DAP_CONFIG --cflags`"
       ac_ncdods_ok='yes'
       AC_MSG_RESULT([yes])
     fi
  fi 
  if test "z$ac_ncdods_ok" = "zno" ; then
     ac_ncdods_dap_ok='no'
     AC_CHECK_DODS([ac_ncdods_dap_ok='yes'],[ac_ncdods_dap_ok='no'])
     if test "z$ac_ncdods_dap_ok" = 'zyes'; then
        NC_DAP_LIBS="$DAP_LIBS -lnc-dods -ldap++"
        NC_DAP_CFLAGS="$DAP_CFLAGS"
        AC_LANG_PUSH([C++])
        dnl We check that linking is succesfull
        ac_save_LIBS="$LIBS"
        ac_save_CFLAGS="$CFLAGS"
        LIBS="$LIBS $NC_DAP_LIBS"
        CFLAGS="$CFLAGS $NC_DAP_CFLAGS"
        AC_CHECK_FUNC([nc_open],[ac_ncdods_ok='yes'],[ac_ncdods_ok='no'])
        LIBS=$ac_save_LIBS
        CFLAGS=$ac_save_CFLAGS
        AC_LANG_POP
     fi
  fi
  if test "x$ac_ncdods_ok" = "xyes" ; then
     m4_if([$1], [], [:], [$1])
  else
     NC_DAP_LIBS=""
     NC_DAP_CFLAGS=""
     m4_if([$2], [], [:], [$2])
  fi
  AC_SUBST([NC_DAP_CFLAGS])
  AC_SUBST([NC_DAP_LIBS])
])
