
/* These macros and the static function nvdims come from the top of the v2i.c
   (netcdf version 2 interface) source file. 03/08/04 jhrg */

#include "netcdf.h"

#if SIZEOF_LONG == SIZEOF_SIZE_T
/*
 * We don't have to copy the arguments to switch from 'long'
 * to 'size_t' or 'ptrdiff_t'. Use dummy macros.
 */

# define NDIMS_DECL
# define A_DECL(name, type, ndims, rhs) \
        const type *const name = ((const type *)(rhs))

# define A_FREE(name)

# define A_INIT(lhs, type, ndims, rhs)

#else 
/*
 * We do have to copy the arguments to switch from 'long'
 * to 'size_t' or 'ptrdiff_t'. In my tests on an SGI,
 * any additional cost was lost in measurement variation.
 */

# include "onstack.h"

static size_t
nvdims(int cdfid, int varid)
{
    int ndim;
    if(nc_inq_varndims(cdfid, varid, &ndim) == NC_NOERR)
	return ndim;

    return 0;

}

#define NDIMS_DECL      const size_t ndims = nvdims(cdfid, varid);

# define A_DECL(name, type, ndims, rhs) \
        ALLOC_ONSTACK(name, type, ndims)

# define A_FREE(name) \
        FREE_ONSTACK(name)

# define A_INIT(lhs, type, ndims, rhs) \
        { \
                const long *lp = rhs; \
                type *tp = lhs; \
                type *const end = lhs + ndims; \
                while(tp < end) \
                { \
                        *tp++ = (type) *lp++; \
                } \
        }


#endif

