require "numru/dcl"

include NumRu

class Parameter
  def initialize(parent=nil)
    if(parent)
      @parent = parent
    else
      @parent = Hash.new
    end
    @value = Hash.new
    @typeinfo = Hash.new
    @set_funcname = Hash.new
    @get_funcname = Hash.new
    @set_call_pattern = Hash.new
    @get_call_pattern = Hash.new
    
  end

  def setall(param)
    @value = param.instance_eval{@value}.dup
    @typeinfo = param.instance_eval{@typeinfo}.dup
    @set_funcname = param.instance_eval{@set_funcname}.dup
    @get_funcname = param.instance_eval{@get_funcname}.dup
    @set_call_pattern = param.instance_eval{@set_call_pattern}.dup
    @get_call_pattern = param.instance_eval{@get_call_pattern}.dup
    self
  end

  def init(key, typeinfo, setfunc, getfunc, set_call, get_call)
    @value[key] = nil
    @typeinfo[key] = typeinfo
    @set_funcname[key] = setfunc
    @get_funcname[key] = getfunc
    @set_call_pattern[key] = set_call
    @get_call_pattern[key] = get_call
  end

  def keys
    @typeinfo.keys
  end

  def dup
    copy = Parameter.new(@parent)

    value = @value.dup
    type = @typeinfo.dup
    set = @set_funcname.dup
    get = @get_funcname.dup
    setpat = @set_call_pattern.dup
    getpat = @get_call_pattern.dup

    copy.instance_eval{@value = value}
    copy.instance_eval{@typeinfo = type}
    copy.instance_eval{@set_funcname = set}
    copy.instance_eval{@get_funcname = get}
    copy.instance_eval{@set_call_pattern = setpat}
    copy.instance_eval{@get_call_pattern = getpat}
    copy
  end

  def valueget(key)
    value = @value[key]
    if(value == nil)
      if(@parent.is_a?(Parameter))
	value = @parent.valueget(key)
	return value
      end
    end
    value
  end

  def [](key)
    val = @value[key]
    pval = @parent[key]
    if(val != nil)  
      return val
    elsif(pval != nil)
      return pval
    else
      case @get_call_pattern[key]
      when 0
	return eval("DCL.#{@get_funcname[key]}(key)")
      when 1
	return eval("DCL.#{@get_funcname[key]}")
      when 2
	return eval("#{@get_funcname[key]}")
      when 3
	return nil
      when nil
	return nil
      else
	raise "inside error of Parameter class: unsupported call pattern"
      end
    end
  end

  def setincpoint(value)
    if(@typeinfo["inclpoint"])
      len = @typeinfo["inclpoint"][0]
      if(value.is_a?(Array) && len == value.length)
	if(value[0]==Fig.rundef && (value[1].is_a?(Array) || value[1].is_a?(NArray)))
	  @value["inclpoint"]=value
	elsif(value[1]==Fig.rundef && (value[0].is_a?(Array) || value[0].is_a?(NArray)))
	  @value["inclpoint"]=value
	elsif((value[1].is_a?(Array) || value[1].is_a?(NArray)) && (value[0].is_a?(Array) || value[0].is_a?(NArray)))
	  @value["inclpoint"]=value
	end
      else
	raise ArgumentError, "type error, argument must be [(N)Array(rundef), (N)Array(rundef)]"
      end
    end
  end

  def []=(key, value)
    if(key=="inclpoint")
      return setincpoint(value)
    end
    begin
      if(@typeinfo[key])
	typeinfo = @typeinfo[key]
	if(typeinfo.is_a?(Class))
	  if(value.is_a?(typeinfo))
	    @value[key] = value
	  elsif(typeinfo == TrueClass)
	    if(value.type == FalseClass)
	      @value[key] = value
	    else
	      raise ArgumentError, "type of value is incorrect"
	    end
	  else
	    raise ArgumentError, "type of value is incorrect"
	  end
	elsif(typeinfo.is_a?(Array))
	  len = typeinfo[0]
	  typeinfo = typeinfo[1]
	  if(typeinfo.is_a?(Class))
	    klass = typeinfo
	    if(value.is_a?(Array)||value.is_a?(NArray))
	      if(value.length == len || len == true)
		value.each{|i|
		  if(!i.is_a?(klass))
		    raise ArgumentError, "type of elements of value is incorrect"
		  end
		}
		@value[key] = value
	      else
		raise ArgumentError, "length of array is incorrect"
	      end
	    else
	      raise ArgumentError, "type of value is incorrect"
	    end
	  elsif(typeinfo.is_a?(Array))
	    len2 = typeinfo[0]
	    klass = typeinfo[1]
	    if(value.is_a?(Array) && (value[0].is_a?(Array) || value[0].is_a?(NArray)) )
	      if((value.length == len || len == true) && (value[0].length == len2 || len2 == true))
		value.each_index{|j|
		  value[j].each{|i|
		    if(!i.is_a?(klass))
		      raise ArgumentError, "type of elements of value is incorrect"
		    end
		  }
		}
		@value[key] = value
	      else
		raise ArgumentError, "length of array is incorrect"
	      end
	    else
	      raise ArgumentError, "type of value is incorrect"
	    end
	  else
	    raise ArgumentError, "type of value is incorrect"
	  end
	else
	  raise ArgumentError, "type of value is incorrect"
	end
      else
	raise ArgumentError, "key,"+key.to_s+" is not available"
      end
    rescue ArgumentError
    end
  end

  def sync
    @value.each{|key, val|
      if((val==nil) && (@parent.valueget(key)!=nil))
	val = @parent[key]
      end
      if(val!=nil)
	case @set_call_pattern[key]
	when 0
	  eval("DCL.#{@set_funcname[key]}(key, val)")
	when 1
	  eval("DCL.#{@set_funcname[key]}(val)")
	when 2
	  args = " "
	  val.each_index{|i|
	    if(i==val.length-1)
	      args = args + "#{val[i]}"
	    else
	      args = args + "#{val[i]}, "
	    end
	  }
	  eval("DCL.#{@set_funcname[key]}("+args+")")
	when 3
	  eval("self.#{@set_funcname[key]}(val)")
	else
	  raise "non supported call-pattern (#{@set_call_pattern[key]}) is called"
	end
      end
    }
  end

#------------------------------------------------

  def set(hash, default=nil, backup=nil)
    if(default)
      backup = backup.setall(self)
    end
    if(hash.is_a?(Hash))
      hash.each{|key, val|
	self[key] = val
	if(default)
	  if(default.type != Parameter)
	    raise ArgumentError, "default type mismatch ( must be Parameter class )"
	  end
	  backup[key] = default[key]
	end
      }
    end
    if(default)
      backup
    else
      nil
    end
  end

  def clear
    @value = Hash.new
  end
end

