require 'rbconfig'
require 'find'
require "ftools"
require 'getopts'

CONFIG = Config::MAKEFILE_CONFIG

a=getopts(nil, 'prefix:')
if a>=2
  raise StandardError, "too many option"
end

prefix = CONFIG["prefix"]
sitedir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/numru"
sitedir.gsub!(/\$\(prefix\)/, CONFIG["prefix"])
sitelibdir = sitedir+"/advanceddcl"

if $OPT_prefix
  sitedir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/numru"
  sitedir.gsub!(/\$\(prefix\)/, $OPT_prefix)
  sitelibdir = sitedir+"/advanceddcl"
end 

srcdir = File.dirname($0)

Dir[File.join(srcdir || ".", "*.rb")].each{|file|
  if(/install.rb/ =~ file)
  elsif(/advanceddcl.rb/ =~ file)
    file = File.basename(file)
    File::makedirs(sitedir)
    File::install(file, sitedir+"/"+file, 0644, true)
  else
    file = File.basename(file)
    File::makedirs(sitelibdir)
    File::install(file, sitelibdir+"/"+file, 0644, true)
  end
}
