# by DCL manual
=begin
==NumRu::AdvancedDCL::Fig
==={W[ɂ
FigW[͐}̃fUCɊւ郂W[łB
===p^
p^ p^̌^ ΉDCLpbP[W
:mapangle (Float(3)) <GRPACK::GRSMPL>
   n}e̋ɂ̐ݒ.
:simtrans (Float(3)) <GRPACK::GRSSIM>
   ϊ̐ݒ.
:transnum (Fixnum) <GRPACK::GRSTRN>
   Kϊ̕ϊ֐ԍw肷. 
:transnum3d (Fixnum) <SCPACK::SCSTRN>
   3}ɂ鐳Kϊ̕ϊ֐ԍw肷. 
:viewport (Float(4)) <GRPACK::GRSVPT>
   Kϊ̂߂̃r[|[gݒ肷. 
:viewport3d (Float(6)) <SCPACK::SCSVPT>
   3}ɂ鐳Kϊ̂߂̃r[|[gݒ肷.
:window (Fixnum(4) or Float(4)) <GRPACK::GRSWND>
   EChE̐ݒ.
:window3d (Fixnum(6) or Float(6)) <SCPACK::SCSWND>
   3}ɂEChE̐ݒ.
:l2to3 (true or false) <SGPACK>
   Qϊ̎w. l2to3  true Ȃ2ʂ3ԂɊt; false ȂVWRW𓯈̂̂ƂĈ.(l false ).
:eyepoint (Fixnum(3) or Float(3)) <SCPACK::SCSEYE>
   _̐ݒ.
:objpoint (Fixnum(3) or Float(3)) <SCPACK::SCSOBJ>
   œ_̐ݒ.
:plane (Fixnum(3) or Float(3)) <SCPACK::SCSPLN>
   2ʂ̊t.
:mapwindow (Fixnum(4) or Float(4)) <GRPACK::GRSTXY>
   n}eɂNbsOEݒ肷B
:origin (Fixnum(4) or Float(4)) <SCPACK::SCSORG>
   XP[Ot@N^[ƌ_̐ݒ.
:log3d (Fixnum(3) or Float(3)) <SCPACK::SCSLOG>
   ΐ̐ݒ.
:contactpoint (Fixnum(3) or Float(3)) <UMPACK::UMSCNT>
   eʂ́uړ_vw肷. contactpoint=[uxc, uyc, rot] ̂ƂA
   * ʏ̉~}@ (@) ł, uyc=0, rot=0 ł. łȂƂΎ@ƂȂ. 
   * ~}@̎, Wܓx (p^ stlat1 )w肳ĂȂ, uyc WܓxƂȂ. Wܓxw肳Ă鎞, ̕WܓxɑΉ~ݒ肵, ꂪ(uxc, uyc) Őڂ悤, ~X. Ȃ킿, Ύ@ɂȂ. 
   * ʐ}@ł, (uxc,uyc,rot) , n}e̋(plx,ply,plrot) ƓӖɂȂ.
:circlewindow (Float(3)) <UMPACK::UMSCWD>
   ~`̃EBhEݒ肷. 
:inclpoint (Array[2, Float]) <USPACK::USSPNT>
   EChE͈͂Ɋ܂߂f[^w肷. 
:stlat1, stlat2 (Float) <SGPACK>
   Wܓx(l0.0, 0.0).
:lclip (true or false) <SGPACK>
   r[|[gł̃NbsÕtO(l false ).
:ldeg (true or false) <SGPACK>
   Pʌn̎w. ldeg  true ȂxPʂƂ; false Ȃ烉WAPʂƂ(l true).
:index (Fixnum) <SGPACK>
    1xڂ̃}[Wɕ`ƃR[i[}[ÑCCfNX(l1).
:lcorner (true or false) <SGPACK>
    R[i[}[N`ǂw肷. true ȂR[i[}[N`; false Ȃ`Ȃ(l true).
:corner (Float) <SGPACK>
    R[i[}[N̒(l0.01).Pʂ͑1xڂ̒ӂ1Ƃ.
:lwide (true or false) <SGPACK>
    (^Cg)`1xڂ̃}[W̒`. true ̂Ƃ}[W̕1xڂ̃t[ςɂƂ; false ̂Ƃ̃}[Wc̕}[W̕Ƃ(l false).
:xpad (Float) <SGPACK>
    1xڂ̃}[Wɕ`̍EɂƂ邷܂̘a𕶎PʂƂĎw肷(l1.0).
:ypad (Float) <SGPACK>
    1xڂ̃}[Wɕ`̏㉺ɂƂ邷܂̘a𕶎PʂƂĎw肷(l1.0).

ȂAFloat(n)ȂǂƂ\L͒gFloatł钷 n ̔zł邱ƂӖAArray[2, Float]ȂǂƂ\L͒gFloat^̔zł钷QArraył邱ƂӖĂB

܂Ãp^̓\bhƂėp邱ƂłBȂ킿AFig.windowŃp^window̎QƂABox.window=Ńp^window̕ύXłB

=end

module NumRu
  module AdvancedDCL
    module Fig
      def param_init
	@param = Parameter.new(Common.param)
	@param.init("mapangle", [3, Float], "grsmpl", "sgqmpl", 2, 1)
	@param.init("simtrans", [3, Float], "grssim", "sgqsim", 2, 1)
	@param.init("transnum", Fixnum, "grstrn", "sgqtrn", 1, 1)
	@param.init("transnum3d", Fixnum, "scstrn", "scqtrn", 1, 1)
	@param.init("viewport", [4, Float], "grsvpt", "sgqvpt", 2, 1)
	@param.init("viewport3d", [6, Float], "scsvpt", "scqvpt", 2, 1)
	@param.init("window", [4, Numeric], "grswnd", "sgqwnd", 2, 1)
	@param.init("window3d", [6, Numeric], "scswnd", "scqwnd", 2, 1)
	@param.init("l2to3", TrueClass, "sglset", "sglset", 0, 0)
	@param.init("eyepoint", [3, Numeric], "scseye", "scqeye", 2, 1)
	@param.init("objpoint", [3, Numeric], "scsobj", "scqobj", 2, 1)
	@param.init("plane", [3, Numeric], "scspln", "scqpln", 2, 1)
	@param.init("mapwindow", [4, Numeric], "grstxy", "grqtxy", 2, 1)
	@param.init("origin", [4, Numeric], "scsorg", "scqorg", 2, 1)
	@param.init("log3d", [3, Numeric], "scslog", "scqlog", 2, 1)
	@param.init("contactpoint", [3, Float], "umscnt", "umqcnt", 2, 1)
	@param.init("circlewindow", [3, Float], "umscwd", "umqcwd", 2, 1)
	@param.init("inclpoint", [2, [true, Float]], "inclpoint", "", 3, nil)
	@param.init("stlat1", Float, "sgrset", "sgrget", 0, 0)
	@param.init("stlat2", Float, "sgrset", "sgrget", 0, 0)
	
	@param.init("lclip", TrueClass, "sglset", "sglget", 0, 0)
	@param.init("lmiss", TrueClass, "gllset", "gllget", 0, 0)
	@param.init("imiss", Fixnum, "gliset", "gliget", 0, 0)
	@param.init("rmiss", Float, "glrset", "glrget", 0, 0)
	@param.init("rundef", Float, "glrset", "glrget", 0, 0)
	@param.init("iundef", Fixnum, "glrset", "glrget", 0, 0)
	@param.init("ldeg", TrueClass, "sglset", "sglget", 0, 0)
	
	@param.init("index", Fixnum, "sgiset", "sgiget", 0, 0)
	@param.init("lcorner", TrueClass, "sglset", "sglget", 0, 0)
	@param.init("corner", Float, "sgrset", "sgrget", 0, 0)
	@param.init("lwide", TrueClass, "sglset", "sglget", 0, 0)
	@param.init("xpad", Float, "sgrset", "sgrget", 0, 0)
	@param.init("ypad", Float, "sgrset", "sgrget", 0, 0)
	
	@ntrsparam = ["lclip", "lmiss", "imiss", "rmiss", "rundef", "iundef", "ldeg", "index", "lcorner", "corner", "lwide", "xpad", "ypad"]
	@temp_param = @param.dup
	@backup = @param.dup
	
	@grstrf = false       # true:called, flase:not called  
	@scstrf = false       # true:called, flase:not called  
      end
    
      private :param_init	
      
      def new
	@grstrf = false
	@scstrf = false
	DCL.grfig
      end
      
# by DCL manual
=begin
---Fig.new
    V}`߂ɕKvȏ. 

    
      Ȃ

    l
    (1)̃\bh GRFIG ĂłB
    (2)̃[`͕ϊ֐Ɋւϐׂāu`v ƂƂ, DCL(rbdcl)ɂ UZPACK, USPACK ̏Ȃ. ̃t[ɕ̐}`Ƃ, 2ڈȍ~̐}`n߂ O, ̂, ̃[`Ă΂Ȃ΂ȂȂ.

=end
 
#------------------- method for parameters----------------------

      def set(key, val)
	@param[key] = val
	@ntrsparam.each{|i|
	  if(i==key)
	    @param.sync
	    return nil
	  end
	}
	trfnew
      end

# by kawanabe
=begin
---Fig.set(key, val)
    p^̐ݒsB

    
    * key:p^(String)
    * val:ݒ肷lB^͊ep^QƂ̂ƁB
    gp
        Fig.set("window", [0.0, 1.0, 0.0, 1.0])      # EBhE[0.0, 1.0, 0.0, 1.0]ɐݒ肷

=end

      def get(key)
	@param[key]
      end

# by kawanabe
=begin
---Fig.get(key)
    p^QƂB

    
    * key:p^(String)
    gp
        Fig.gox("window")      # EBhEQƂ

=end

      def settrf
	if(!@grstrf)
	  @param.sync
	  DCL.uspfit
	  DCL.scsprj
	  DCL.grstrf
	  trfclear
	end
      end
      
      def setumtrf
	if(!@grstrf)
	  @param.sync
	  DCL.umpfit
	  DCL.scsprj
	  DCL.grstrf
	  trfclear
	end
      end
      
      def set3dtrf
	if(!@grstrf)
	  @param.sync
	  DCL.scsprj
	  DCL.scstrf
	  trfclear
	end
      end
      
      def trfclear
	@grstrf = true
	@scstrf = true
      end
      
      def trfnew
	@grstrf = false
	@scstrf = false
      end
      
      def sname2lname(sname)
	DCL.sgtrsl(sname)
      end

# by DCL manual (modified a little)
=begin
---Fig.sname2lname(sname)
    ϊ֐̗̂疼̂߂D

    
    * sname (String) : ϊ֐̗

    gp
      Fig.sname2lname('MER')       #Jg}@̗'MER'疼'MERCATOR'𓾂B

=end

      def sname2trn(sname)
	DCL.sgtrsn(sname)
      end

# by DCL manual (modified a little)
=begin
---Fig.sname2trn(sname)
    ϊ֐̗̂ϊ֐ԍ߂D

    
    * sname (String) : ϊ֐̗

    gp
      Fig.sname2trn('MER')       #Jg}@̗'MER'ϊ֐ԍ11𓾂B

=end

      def lname2sname(lname)
	DCL.sgtrls(lname)
      end

# by DCL manual (modified a little)
=begin
---Fig.lname2sname(lname)
    ϊ֐̖̂痪̂߂D

    
    * sname (String) : ϊ֐̖

    gp
      Fig.lname2sname('MERCATOR')       #Jg}@̖'MERCATOR'痪'MER'𓾂B

=end

      def lname2trn(lname)
	DCL.sgtrln(lname)
      end

# by DCL manual (modified a little)
=begin
---Fig.lname2trn(lname)
    ϊ֐̖̂ϊ֐ԍ߂D

    
    * sname (String) : ϊ֐̖

    gp
      Fig.lname2trn('MERCATOR')       #Jg}@̖'MERCATOR'ϊ֐ԍ11𓾂B

=end

      def trn2sname(num)
	DCL.sgtrns(num)
      end

# by DCL manual (modified a little)
=begin
---Fig.trn2sname(num)
    ϊ֐ԍ痪̂߂D

    
    * num (Fixnum) : ϊ֐ԍ

    gp
      Fig.trn2sname(11)       #Jg}@̕ϊ֐ԍ11痪'MER'𓾂B

=end

      def trn2lname(num)
	DCL.sgtrnl(num)
      end

# by DCL manual (modified a little)
=begin
---Fig.trn2lname(num)
    ϊ֐ԍ疼̂߂D

    
    * num (Fixnum) : ϊ֐ԍ

    gp
      Fig.trn2lname(11)       #Jg}@̕ϊ֐ԍ11疼'MERCATOR'𓾂B

=end

#----------- draw method -------------

      def pvpr(index)
	DCL.slpvpr(index)
      end

# by DCL manual
=begin
---Fig.pvpr(index)
    r[|[g̘g`. 

    
    * index (Fixnum) : ̃CCfNX (l1).

    l
    (1)̃\bh SLPVPR ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      def pwwr(index)
	DCL.slpwwr(index)
      end

# by DCL manual
=begin
---Fig.pwwr(index)
    [NXe[VEChE̘g`.

    
    * index (Fixnum) : ̃CCfNX (l1).

    l
    (1)̃\bh SLPWWR ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      def pwvr(index)
	DCL.slpwvr(index)
      end

# by DCL manual
=begin
---Fig.pwvr(index)
    ő̘̈g`. 

    
    * index (Fixnum) : ̃CCfNX (l1).

    l
    (1)̃\bh SLPWVR ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      def pvpc(index, rc)
	DCL.pvpc(index, rc)
      end

# by DCL manual
=begin
---Fig.pvpc(index, rc)
    r[|[g̃R[i[}[N`. 

    
    * index (Fixnum) : ̃CCfNX (l1).
    * rc (Float) : R[i[}[N̒(PʂRWn).

    l
    (1)̃\bh SLPVPC ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 
    (3)rc 0傫Ȃ΂ȂȂ.  rc 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      def pwwc(index, rc)
	DCL.pwwc(index, rc)
      end

# by DCL manual
=begin
---Fig.pwwc(index, rc)
    [NXe[VEChẼR[i[}[N`. 

    
    * index (Fixnum) : ̃CCfNX (l1).
    * rc (Float) : R[i[}[N̒(PʂRWn).

    l
    (1)̃\bh SLPWWC ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 
    (3)rc 0傫Ȃ΂ȂȂ.  rc 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      def pwvc(index, rc)
	DCL.slpwvc(index, rc)
      end

# by DCL manual
=begin
---Fig.pwwc(index, rc)
    ő̈̃R[i[}[N`. 

    
    * index (Fixnum) : ̃CCfNX (l1).
    * rc (Float) : R[i[}[N̒(PʂRWn).

    l
    (1)̃\bh SLPWVC ĂłB
    (2)index 1ȏłȂ΂ȂȂ.  index 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 
    (3)rc 0傫Ȃ΂ȂȂ.  rc 0̂Ƃ, bZ[W͏o͂邪ȂɂȂ. 

=end

      private :trfclear
      
      module_function :param_init
      module_function :new
      module_function :set
      module_function :settrf
      module_function :setumtrf
      module_function :trfnew
      module_function :trfclear
      module_function :set3dtrf
      module_function :sname2lname
      module_function :sname2trn
      module_function :lname2sname
      module_function :lname2trn
      module_function :trn2sname
      module_function :trn2lname
      module_function :pvpr
      module_function :pwwr
      module_function :pwvr
      module_function :pvpc
      module_function :pwwc
      module_function :pwvc
      
      param_init

#------------------- singleton methods ----------------------

      def @param.inclpoint(point)
	rundef = Fig.rundef
	if(rundef==point[0])
	  DCL.usspnt(point[1].length, point[0], point[1])
	elsif(rundef==point[1])
	  DCL.usspnt(point[0].length, point[0], point[1])
	else
	  if(point[0].length != point[1].length)
	    DCL.usspnt(point[0].length, point[0], rundef)
	    DCL.usspnt(point[1].length, rundef, point[1])
	  else
	    DCL.usspnt(point[0].length, point[0], point[1])
	  end
	end
      end
      
      def @temp_param.inclpoint(point)
	rundef = Fig.rundef
	if(rundef==point[0])
	  DCL.usspnt(point[1].length, point[0], point[1])
	elsif(rundef==point[1])
	  DCL.usspnt(point[0].length, point[0], point[1])
	else
	  if(point[0].length != point[1].length)
	    DCL.usspnt(point[0].length, point[0], rundef)
	    DCL.usspnt(point[1].length, rundef, point[1])
	  else
	    DCL.usspnt(point[0].length, point[0], point[1])
	  end
	end
      end
      
      def @backup.inclpoint(point)
	rundef = Fig.rundef
	if(rundef==point[0])
	  DCL.usspnt(point[1].length, point[0], point[1])
	elsif(rundef==point[1])
	  DCL.usspnt(point[0].length, point[0], point[1])
	else
	  if(point[0].length != point[1].length)
	    DCL.usspnt(point[0].length, point[0], rundef)
	    DCL.usspnt(point[1].length, rundef, point[1])
	  else
	    DCL.usspnt(point[0].length, point[0], point[1])
	  end
	end
      end

#----------------------------------------------------------

      @param.keys.each{|i|
	eval "def #{i}; @param['#{i}']; end"
	eval "def #{i}=(val); set('#{i}', val); end"
      }
      
      @param.keys.each{|i|
	eval "module_function :#{i}"
	eval "module_function :#{i}="
      }
    end
  end
end
