require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


nx = 21
ny = 21
xmin = -10
xmax = 10
ymin = -10
ymax = 10
dx1 = 1
dx2 = 5
dy1 = 1
dy2 = 5
kmax = 5
pmin = 0
pmax = 1
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
p = NArray.sfloat(nx, ny)
pi = NArray.sfloat(2, kmax+1)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    u[i,j] =  x
    v[i,j] = -y
    p[i,j] = exp(-x**2/64 -y**2/25)
  end
end

#-- graph ---

Dev.open("X")

Tone.lsoftf=true
Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis::Lin.xaxdv('B', dx1, dx2)
Axis::Lin.xaxdv('T', dx1, dx2)
Axis::Lin.xsttl('B', 'X-axis', 0.0)
Axis::Lin.xmttl('T', 'FIGURE TITLE', 0.0)

Axis::Lin.yaxdv('L', dy1, dy2)
Axis::Lin.yaxdv('R', dy1, dy2)
Axis::Lin.ysttl('L', 'Y-axis', 0.0)

Vector.lunit=true
Vector.vxuoff=0.04
Vector.uvtitle('X', 'U')
Vector.uvtitle('Y', 'V')
Vector.draw(u, v)

Contour.label=false
Contour.lmsg= false
Contour.gclb(p, 0.1)
Contour.draw(p)

dp = (pmax-pmin)/kmax.to_f
for k in 1..kmax
  tlev1 = (k-1)*dp
  tlev2 = tlev1 + dp
  ipat  = 600 + k - 1
  Tone.stlv(tlev1, tlev2, ipat)
end
Tone.draw(p)

#-- g[o[ ----
Fig.window=[0.0, 1.0, pmin, pmax]
Fig.viewport=[0.85, 0.9, 0.45, 0.75]
Fig.transnum=1

for k in 1..kmax+1
  pi[0,k-1] = pmin + (k-1)*dp
  pi[1,k-1] = pmin + (k-1)*dp
end

Contour.draw(pi)
Tone.draw(pi)

Fig.pvpr(3)
Axis.labelyr=true

Axis::Lin.zfact(0.8)
Axis::Lin.cyfmt='(F4.1)'
Axis::Lin.yaxdv('R', dp, dp)

Dev.close
