require "numru/advanceddcl"

include NumRu::AdvancedDCL

x1 = -180.0
x2 = +180.0
dx1 = 10.0
dx2 = 60.0
y1 = -90.0
y2 = +90.0
dy1 = 10.0
dy2 = 30.0

#-- graph ---
Dev.open("X")
Frame.new

Fig.set("window", [x1, x2, y1, y2])
Fig.set("viewport", [0.2, 0.8, 0.3, 0.7])
Fig.set("transnum", 1)

Axis::Lin.set("inner", -1)
Axis::Lin.set("uxuser", 0.0)
Axis::Lin.set("uyuser", 0.0)
Axis::Lin.set("labelxu", false)
Axis::Lin.set("labelyu", false)

Axis::Lin.xaxdv('B', dx1, dx2)
Axis::Lin.xaxdv('T', dx1, dx2)
Axis::Lin.xsttl('B', 'LONGITUDE', 0.0)

Axis::Lin.yaxdv('L', dy1, dy2)
Axis::Lin.yaxdv('R', dy1, dy2)
Axis::Lin.ysttl('L', 'LATITUDE', 0.0)

Axis::Lin.xmttl('T', 'UXAXDV/UYAXDV', 0.0)

#Axis::Lin.zfact(0.5)
Axis::Lin.xaxdv('U', dx1, dx2)
Axis::Lin.xsttl('U', 'EQ', +0.9)
Axis::Lin.yaxdv('U', dy1, dy2)
Axis::Lin.ysttl('U', 'GM', -0.9)
Axis::Lin.set("inner", +1)
Axis::Lin.xaxdv('U', dx1, dx2)
Axis::Lin.yaxdv('U', dy1, dy2)

Dev.close
