require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


max = 5

#-- data ---
xnec = NArray[1.2, 2.5, 3.3, 3.7, 3.1]
xapl = NArray[1.3, 2.6, 3.8, 4.4, 4.5]
xibm = NArray[1.7, 2.2, 3.5, 4.2, 5.7]

rundef = Fig.rundef

#-- graph ---
Dev.open("X")

Frame.new

Fig.window=[0.0, 5.0, 0.0, 6.0]

Axis.draw

Bar.variablerange=[0.3, 4.3]
Bar.itpat=[2999, 2999]
Bar.xtone(rundef, xnec, rundef)
Bar.xfrm(rundef, xnec, rundef)
p Fig.window
Bar.variablerange=[0.5, 4.5]
Bar.itpat=[3999, 3999]
Bar.xtone(rundef, xapl, rundef)
Bar.xfrm(rundef, xapl, rundef)

Bar.variablerange=[0.7, 4.7]
Bar.itpat=[4999, 4999]
Bar.xtone(rundef, xibm, rundef)
Bar.xfrm(rundef, xibm, rundef)

Frame.new

for i in 0..max-1
  xapl[i] = xnec[i] + xapl[i]
  xibm[i] = xapl[i] + xibm[i]
end

Fig.window=[0.0, 5.0, 0, 14]

Axis.draw

Bar.variablerange=[0.5, 4.5]

Bar.itpat=[2999, 2999]
Bar.barwidth=0.05
Bar.xtone(rundef, xnec, rundef)
Bar.itpat=[3999, 3999]
Bar.xtone(rundef, xnec, xapl)
Bar.itpat=[4999, 4999]
Bar.xtone(rundef, xapl, xibm)

Bar.xfrm(rundef, xnec, rundef)
Bar.xfrm(rundef, xnec, xapl)
Bar.xfrm(rundef, xapl, xibm)

Bar.xline(rundef, xnec)
Bar.xline(rundef, xapl)
Bar.xline(rundef, xibm)

Dev.close

