require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


n = 20
m = 5
x0 = NArray.sfloat(n)
x1 = NArray.sfloat(n)
x2 = NArray.sfloat(n)
y0 = NArray.sfloat(n)
y1 = NArray.sfloat(n)
y2 = NArray.sfloat(n)
a = NArray.sfloat(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  x0[i] = dt*i
  y1[i] = a[0]*cos(t)
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i]  = y2[i] + yy
  end

  y0[i] = (y1[i]+y2[i])/2.0
  dy = (y1[i] - y2[i]).abs
  x1[i] = x0[i] - dy/5
  x2[i] = x0[i] + dy/5
end

#-----------------------------------------------------------------------

Dev.open("X")

Frame.new
Fig.lclip= true

Fig.inclpoint=[x0, y0]
#usspnt(N, x1, y1)
#usspnt(N, x2, y2)

Axis.draw

Errbar.xdraw(x0, y1, y2)

Errbar.errbartype=3
Errbar.errbarindex=33
Errbar.ydraw(x1, x2, y0)

Mark.marktype=4
Mark.markindex=21
Mark.draw(x0, y0)

Dev.close

