require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


n = 30
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
r = 0.2
a = 3.7
for i in 0..n-1
  r = a*r*(1.0-r)
  y[i] = r
end

y[n/2-1] = 999.0
Fig.lmiss= true
rundef = Fig.rundef

#----------------------------- GRAPH -----------------------------------

Dev.open("X")

Frame.new
Fig.lclip=true

Fig.window=[0.0, 1.0, rundef, rundef]
#Fig.inclpoint=[[rundef], y]

Axis.draw

Plot.lineindex=2
Plot.draw(rundef, y)

Mark.marktype=4
Mark.draw(rundef, y)

Dev.close

