require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

nt = 51
nz = 21
zmin = 20.0
zmax = 50.0
tmax = 5.0
dz = (zmax-zmin)/(nz-1)
dt = tmax/(nt-1)
u = NArray.sfloat(nt, nz)
t = NArray.sfloat(nt)
z = NArray.sfloat(nz)
#-----------------------------------------------------------------------
for j in 0..nz-1
  z[j] = dz*j + zmin
  uz = exp(-0.2*z[j])*(z[j]**0.5)
  for i in 0..nt-1
    t[i]  = dt*i - 2.0*exp(-0.1*z[j])
    u[i,j] = uz*sin(3.0*t[i])
  end
end

#-----------------------------------------------------------------------
Dev.open("X")

Frame.new

Fig.window=[0.0, tmax, zmin, zmax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis.title('TIME', 'YEAR', 'HEIGHT', 'km')

Axis.draw

Contour.draw(u)

Dev.close
