require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


n = 400
x = NArray.sfloat(n)
y = NArray.sfloat(n)

#-----------------------------------------------------------------------
dt = 2*PI/(n-1)
x = x.indgen * dt
y = y.indgen * 2 * dt
y = sin(y) * 10.0

#---------------------------- 1ST PAGE ---------------------------------
Dev.open("X")

Frame.new
Axis.draw(x, y)
Plot.draw(x, y)

#---------------------------- 2ND PAGE ---------------------------------
Frame.new

Axis.dxl=1.25
Axis.dxt=0.25

Axis.xfac=0.1
Axis.yfac=10.0

Axis.draw(x, y)
Plot.draw(x, y)

#-----------------------------------------------------------------------

Dev.close



