require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL

n = 200
t = NArray.sfloat(n)
a = NArray.sfloat(n)
x, y, z, s, r, b, dt = [0.0, 1.0, 1.0, 10.0, 26.0, 2.6, 0.01]

#-----------------------------------------------------------------------
for i in 0..n-1
  for j in 0..7
    dx = -s*x + s*y
    dy = -x*z + r*x - y
    dz =  x*y - b*z
    x = x + dx*dt
    y = y + dy*dt
    z = z + dz*dt
  end
  t[i] = i*1000
  a[i] = y + 20.0
end

#-----------------------------------------------------------------------
Dev.open("X")

Frame.new

Fig.inclpoint=[t, a]
Axis.title('TIME', 'SEC', 'HEAT FLUX', 'W/m|2"')
Axis.draw
Plot.draw(t, a)

Dev.close
