require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

n = 200
m = 5
x = Array.new(n)
y0 = Array.new(n)
y1 = Array.new(n)
y2 = Array.new(n)
a = Array.new(m)

#------------------------------ data set ---------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  x[i] = dt*i
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i] = y2[i] + yy
  end
  y1[i] = a[0]*cos(t)

  if (t < PI/2.0 || t >= PI*3.0/2.0)
    y0[i] = -0.5
  else
    y0[i] = 0.5
  end
end

#--------------------------- plot ----------------------------------
Dev.open("X")

Frame.new

Fig.inclpoint=[x, y1]

Axis.draw(x, y1)

Plot.draw(x, y1, {"linetype"=>3, "lineindex"=>1})
Plot.draw(x, y2, {"linetype"=>2, "lineindex"=>2})
Plot.draw(x, y0, {"linetype"=>1, "lineindex"=>5})

Dev.close


