require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

n = 100
x = NArray.sfloat(n)
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
r = 0.2
a = 3.6
r0 = 0.0
for i in 0..n-1
  r = a*r*(1.0-r)
  r0 = r0 + r*4 - 2.58
  x2 = (i-49.0)**2
  rexp = 4.0*(i+1)/n
  x[i] = 10.0**rexp
  y[i] = 1.0e5*exp(-x2) + 10.0**r0
end
y[19] = 1.0e4
y[39] = 2.0e3
y[64] = 3.0e4
y[69] = 5.0e2

#----------------------------- GRAPH -----------------------------------
Dev.open("X")

Frame.new
Fig.transnum=4

Fig.inclpoint=[x, y]
p Fig.inclpoint
Axis.draw
Plot.draw(x, y)

Dev.close

#-----------------------------------------------------------------------
