require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


np = 14
nx = 73
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90
p = NArray.sfloat(nx*ny)

#-- data ---
ctr = ['cyl','mer','mwd','hmr','ek6','ktd','con',
       'coa','coc','bon','otg','pst','azm','aza']
fct = NArray[0.12, 0.12, 0.14, 0.14, 0.14, 0.14, 0.11,
               0.16, 0.12, 0.12, 0.40, 0.12, 0.12, 0.17]

i = 0
File.foreach('t811231.dat') do |line|
  line.split(" ").each do |data|
    p[i] = data.to_f
    i += 1
  end
end
p.reshape!(nx, ny)

190.step(245, 5) do |r|
  amin=r
  amax=r+5
#       IDX=(R-180)*1.4*1000+999
  idx=((r-170)*1.25).to_i*1000+999
  Tone.stlv(amin, amax, idx)
end

#-- graph ---
Dev.open("X")

Tone.lsoftf = false
Fig.stlat1 = 75.0
Fig.stlat2 = 60.0
Map.lgridmj = false
Map.dgridmn = 30.0

Fig.mapangle=[165.0, 60.0, 0.0]
Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.window=[xmin, xmax, ymin, ymax]

Fig.lclip = true

Text.charsize = 0.03
Text.charrot = 0
Text.charcent = 0
Text.charindex = 3

for i in 0..np-1
  Frame.new
  Fig.simtrans=[fct[i], 0.0, 0.0]

  if (ctr[i] == 'otg')
    Fig.mapwindow=[-180.0, 180.0, 0.0, 90.0]
  else
    Fig.mapwindow=[-180.0, 180.0, -90.0, 90.0]
  end
  Fig.transnum = Fig.sname2trn(ctr[i])
  
  Fig.pwwr(1)
  Fig.pvpr(1)
  cttl = Fig.sname2lname(ctr[i])
  Text.rdraw(0.5, 0.95, cttl)
  Map.settrf

  Tone.draw(p)
  Contour.draw(p)
  
  Map.open('coast_world')
  Map.draw

  Fig.pvpr(1)
end

Dev.close

