require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


np = 14

#-- data ---
ctr = ['cyl','mer','mwd','hmr','ek6','ktd','con',
       'coa','coc','bon','otg','pst','azm','aza']
fct = NArray[0.12, 0.12, 0.14, 0.14, 0.14, 0.14, 0.11,
               0.16, 0.12, 0.12, 0.40, 0.12, 0.12, 0.17]

#-- graph ---

Dev.open("X")

Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.lclip = true

Text.charsize = 0.03
Text.charrot = 0
Text.charcent = 0
Text.charindex = 3
for i in 0..np-1
  Frame.new

  Fig.transnum = Fig.sname2trn(ctr[i])
  
  Fig.pwwr(1)
  Fig.pvpr(1)
  cttl = Fig.sname2lname(ctr[i])
  Text.rdraw(0.5, 0.95, cttl)

  Map.open('coast_world')
  Map.draw
end

Dev.close

