require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


nx = 19
ny = 19
xmin = 0
xmax = 360
dx1 = 20
dx2 = 60
ymin = -90
ymax = +90
dy1 = 10
dy2 = 30
drad = PI/180
dz = 0.05

p = NArray.sfloat(nx, ny)
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

rmiss = DCL.glrget('RMISS')
DCL.gllset('LMISS', true)

for j in 0..ny-1
  for i in 0..nx-1
    if (j == 0 || j == ny-1)
      u[i,j]=rmiss
      v[i,j]=rmiss
    else
      u[i,j] = p[i,j-1] - p[i,j+1]
      v[i,j] = p[DCL.imod(i+1,nx-1),j] - p[DCL.imod(i-1,nx-1),j]
    end
  end
end

#-- graph ---
Dev.open("X")

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis::Lin.xaxdv('B', dx1, dx2)
Axis::Lin.xaxdv('T', dx1, dx2)
Axis::Lin.xsttl('B', 'LONGITUDE', 0.0)

Axis::Lin.yaxdv('L', dy1, dy2)
Axis::Lin.yaxdv('R', dy1, dy2)
Axis::Lin.ysttl('L', 'LATITUDE', 0.0)

Contour.labelsize=0.015
Contour.titlesize=0.015
Contour.draw(p)


Vector.rsizet=0.015
Vector.lnrmal=false
Vector.xfact1=0.025
Vector.yfact1=0.050
Vector.lunit=true
Vector.uvtitle('X', 'U')
Vector.uvtitle('Y', 'V')
Vector.vxunit=0.05
Vector.vyunit=0.10
Vector.draw(u, v)

Dev.close
