require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI/180
dz = 0.05
p = NArray.sfloat(nx, ny)

#-- data ---
rmiss = DCL.glrget('RMISS')
DCL.gllset('LMISS', true)

for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    if ((i == 2 && j == 14) || ((8 <= i && i <= 11) && (6 <= j && j <= 10)))
      p[i,j]=rmiss
    else
      p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
    end
  end
end

#-- graph ---
Dev.open("X")

Tone.lsoftf=true
Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis.draw

Contour.draw(p)
Tone.draw(p)

Dev.close
