require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath


nx = 19
ny = 19
xmin = 0
xmax = 360
dx1 = 10
dx2 = 60
ymin = -90
ymax = 90
my = 7
nc = 3
drad = PI/180
dz = 0.05
p = NArray.sfloat(nx, ny)
uy1 = NArray.sfloat(ny)
uy2 = NArray.sfloat(my)
x = NArray.sfloat(nx)
#-- data ---
ch = ['SP ', '60S', '30S', 'EQ ', '30N', '60N', 'NP ']

for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

uy1.indgen(ymin, (ymax-ymin)/(ny-1).to_f)
uy1 = sin(uy1*drad)
uy2.indgen(ymin, (ymax-ymin)/(my-1).to_f)
uy2 = sin(uy2*drad)
x.indgen(xmin, (xmax-xmin)/(nx-1).to_f)

#-- graph ---
Dev.open("X")

Frame.new

#Fig.window=[xmin.to_f, xmax.to_f, uy1[0], uy1[ny-1]]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis::Lin.xaxdv('B', dx1, dx2, x, uy1)
Axis::Lin.xaxdv('T', dx1, dx2)
Axis::Lin.xsttl('B', 'LONGITUDE', 0.0)

Axis::Lin.yaxlb('L', uy1, uy2, ch)
Axis::Lin.yaxlb('R', uy1, uy2, ch)
Axis::Lin.ysttl('L', 'LATITUDE', 0.0)

Contour.labelfmt='(F6.1)'

Contour.gclb(p, 0.2)
Contour.sclv(0.1, 1, 4, ' ', 0.01)

Contour.draw(p)

Dev.close

