require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI/180
dz = 0.05
p = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

#-- graph ---
Dev.open("X")

Frame.new

#Fig.window=[xmin.to_f, xmax.to_f, ymin.to_f, ymax.to_f]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis.draw(p)
Contour.draw(p)

Dev.close
