require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

nd = 12
ddeg = 360.0/nd
dd = 0.25

rx = dd * (NArray.sfloat(nd).indgen + 1) * (cos(NArray.sfloat(nd).indgen*PI*ddeg/180))
ry = dd * (NArray.sfloat(nd).indgen + 1) * (sin(NArray.sfloat(nd).indgen*PI*ddeg/180))

Dev.open("X")
Frame.new

Fig.window=[0.0, 10.0, 0.0, 10.0]
Fig.viewport=[0.0, 1.0, 0.0, 1.0]
Fig.transnum=1

x1 = 3.0
y1 = 7.0
(0..(nd-1)).each{|i|
  Arrow.draw(x1, y1, x1+rx[i], y1+ry[i], {"arrowtype"=>1, "arrowindex"=>2})
}

Arrow.lprop=false
Arrow.const=0.05

x1 = 7.0
y1 = 7.0
(0..(nd-1)).each{|i|
  Arrow.draw(x1, y1, x1+rx[i], y1+ry[i], {"arrowtype"=>1, "arrowindex"=>2})
}

m = NArray.sfloat(8).indgen
(0..7).each{|i|
  Arrow.angle=10*m[i]
  Arrow.draw(m[i], 2.0, m[i]+1, 3.0, {"arrowtype"=>1, "arrowindex"=>2})
}

Dev.close
