require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include NMath

upx3 = NArray.sfloat(3).indgen
upy3 = NArray.sfloat(3).indgen
upx6 = NArray.sfloat(6).indgen
upy6 = NArray.sfloat(6).indgen
upxs = NArray.sfloat(61).indgen
upys = NArray.sfloat(61)

#-- data ---
a = 0.8
th = 3.14159 * 2 / 3
upy3 = upy3.indgen * th + th
upx3 = sin(upy3) * a
upy3 = cos(upy3) * a

th = 3.14159 * 2 / 6
upy6 = upy6.indgen * th + th
upx6 = sin(upy6) * a
upy6 = cos(upy6) * a

th = 3.14159 * 4 / 60
upxs = upxs.indgen * a/30 - a
upys = upys.indgen * th 
upys = sin(upys) * a

#-- graph ---
Dev.open("X")

Tone.lsoftf=true
Frame.new

Fig.window=[-1.0, 1.0, -1.0, 1.0]
Fig.viewport=[0.0, 0.5, 0.0, 0.5]
Fig.transnum=1

Plot.draw(upx3, upy3)
Tone.fill(upx3, upy3)

Fig.viewport=[0.0, 0.5, 0.5, 1.0]
Tone.tonepat=101
Tone.fill(upx6, upy6)

Fig.viewport=[0.5, 1.0, 0.0, 0.5]
Tone.fill(upx6, upy6, {"tonepat"=>201})

Fig.viewport=[0.5, 1.0 ,0.5, 1.0]
Tone.fill(upxs, upys, {"tonepat"=>601})

Dev.close 
