require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include Math

n = 41
x = NArray.sfloat(n)
y = NArray.sfloat(n)

dt = 4 * PI / n
(0..(n-1)).each{|i|
  y[i] = sin(dt * i) * 0.15
  x[i] = i / (n-1.0)
}

Dev.open("X")

#------------------ page 1 -----------------------
Frame.new

Fig.window=[0.0, 1.0, -0.8, 0.2]
Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.transnum=1

Fig.lclip=true
Mark.draw(x, y)

Fig.window=[0.0, 1.0, -0.7, 0.3]
Mark.marktype=2
Mark.draw(x, y)

Fig.window=[0.0, 1.0, -0.6, 0.4]
Mark.marktype=3
Mark.draw(x, y)

Fig.window=[0.0, 1.0, -0.5, 0.5]
Mark.marktype=4
Mark.draw(x, y)

Fig.window=[0.0, 1.0, -0.4, 0.6]
Mark.markindex=2
Mark.draw(x, y)

Fig.window=[0.0, 1.0, -0.3, 0.7]
Mark.markindex=3
Mark.marktype=2
Plot.draw(x, y)
Mark.draw(x, y)

n1=n/4
y[(n1-1)..(n1+1)]=999
n2=n1*3
y[n2-1]=999
y[n2+1]=999

Fig.window=[0.0, 1.0, -0.2, 0.8]
Fig.lmiss=true
Mark.markindex=2
Mark.marksize=3

Plot.draw(x, y)
Mark.draw(x, y)

Fig.pvpr(1)

Dev.close
