require "narray"
require "numru/advanceddcl"

include NumRu::AdvancedDCL
include Math

n = 41
x = NArray.sfloat(n)
y = NArray.sfloat(n)

dt = 4 * PI / n
(0..(n-1)).each{|i|
  y[i] = sin(dt * i) * 0.15
  x[i] = i / (n-1.0)
}

Dev.open("X")

#------------------ page 1 -----------------------
Frame.new

Fig.set("window", [0.0, 1.0, -0.8, 0.2])
Fig.set("viewport", [0.15, 0.85, 0.1, 0.9])
Fig.set("transnum", 1)

Plot.draw(x, y)

Fig.set("window", [0.0, 1.0, -0.7, 0.3])
Plot.set("lineindex", 2)
Plot.draw(x, y)

Fig.set("window", [0.0, 1.0, -0.6, 0.4])
Plot.set("lineindex", 3)
Plot.draw(x, y)

Fig.set("window", [0.0, 1.0, -0.4, 0.6])
Plot.set("linetype", 2)
Plot.draw(x, y)

Fig.set("window", [0.0, 1.0, -0.3, 0.7])
Plot.set("linetype", 3)
Plot.draw(x, y)

Fig.set("window", [0.0, 1.0, -0.2, 0.8])
Plot.set("linetype", 4)
Plot.draw(x, y)
Fig.pvpr(1)

Dev.close

