require "narray"
require "numru/advanceddcl"
include NumRu::AdvancedDCL
include NMath


nmax = 50
x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1)

#-- data ---
x.indgen(1950.0, 1.0)
r    = 3.7
y[0] = 0.5
for n in 0..nmax-1
  y[n+1] = r*y[n]*(1.0-y[n])
end
yave = DCL.rave(y, nmax+1, 1)
y = -4 * (y - yave)

#-- graph ---
Dev.open("X")

Frame.new

Fig.window=[x[0], x[nmax], -1.5, 2.0]
Fig.viewport=[0.2, 0.9, 0.2, 0.9]
Fig.transnum=1

Text.ifont=2
Axis::Lin.indext1=402
Axis::Lin.indext2=404
Axis::Lin.indexl1=303
Axis::Lin.indexl2=123
Axis::Lin.xaxdv('B', 2.0, 10.0)
Axis::Lin.xaxdv('T', 2.0, 10.0)
Axis::Lin.xsttl('B', 'YEAR', 0.0)

Axis::Lin.yaxdv('L', 0.1, 0.5)
Axis::Lin.yaxdv('R', 0.1, 0.5)
cttl = DCL.csgi(131) + 'T [K]'
Axis::Lin.ysttl('L', cttl, 0.0)

Axis::Lin.xmttl('T', 'INTERANNUAL VARIATION', 0.0)

Plot.lineindex=24
Plot.draw(x, y)

Dev.close
