# by DCL manual
=begin
==NumRu::AdvancedDCL::Contour
==={W[ɂ
ContourW[͓}`߂̃W[łB
UWnō悳̂, ׂĂ̐KϊɑΉĂ. ̃W[ł, }`ōWȂǂ̊Og͕`Ȃ. 

Contour ɂă[U[gp郁\bhƂĂ͈ȉ̂悤Ȃ̂. 
* 惁\bh
  * draw DDD2}悷 
* R^[xɊւ郁\bh 
  * gcla DDDŏlEőlEݒlŐ.
  * gclb DDDiq_l^zƂݒlŐ.
  * iclv DDDR^[x𖳌ɂ.
  * sclv DDD1{̃R^[x𐶐.
  * dclv DDD1{̃R^[x폜.
* ̑̃\bh
  * set, get DDDϐQ/ύX.

iq_WɊւẮA惁\bhɊiq_(WlƂ)^ƎIɐݒ肵Ă.

2f[^ƂɂR^O(quick look)ƂƂɂ, P Contour.draw ĂԂł悢. ̂Ƃ, ݐݒ肳ĂEChEς Ԋůiq_ݒ肵, R^[xIɐ. 

iq_sԊȕꍇ, iq_̍Wl`惁\bḧƂĎw肷΂悢.

܂R^[x炩ߎw肵Ƃ, Contour.draw ĂԑO Contour.gcla ܂ Contour.gclb Ăׂ΂悢. ̏ꍇ, ԊũR^[xȂ. , sԊũR^[xw肵ꍇ, ̃R^[xǉꍇ, Contour.sclv 1{1{̃R^[x𐶐Ă΂悢. (1{̃R^[x𖳌ɂɂ Contour.dclv Ăׂ΂悢; ׂẴR^[x𖳌ɂɂ Contour.iclv Ăׂ΂悢. ) 

===p^
p^ p^̌^ ΉDCLpbP[W
:indexmj (Fixnum) <UDPACK>
   major line ̃CCfNX(l3).
:indexmn (Fixnum) <UDPACK>
   minor line ̃CCfNX(l1).
:label (true or false) <UDPACK>
   major line Ƀx邩ǂ̎w. true Ȃ; false ȂȂ(l true ).
:ldash (true or false) <UDPACK>
   ̃R^[CقȂ郉C^Cvŕ`ǂw肷. true ̂Ƃ̃R^[Cp^ idash ̎QƂ郉C^Cvŕ`; false ̂ƂׂẴR^[Cp^ isolid ̎QƂ郉C^Cvŕ`(l true ).
:idash (Fixnum) <UDPACK>
   ldash  true ̂Ƃ,̃R^[xɎgC^Cv(l3:j).
:isolid (Fixnum) <UDPACK>
   ldash  true ̂Ƃ0ȏ̃R^[x,܂ ldash  false ̂ƂׂẴR^[xɎgC^Cv(l1:).
:icycle (Fixnum) <UDPACK>
   minor line  major line ̊Ԃɉ{w肷. Ȃ킿 icycle ŎQƂl1{̊ major line , c minor line (l2).
:nlev (Fixnum) <UDPACK>
   R^[xIɐƂ,̓ϐQƂĖ nlev {̃R^[x𐶐(l12).
:labelsize (Float) <UDPACK>
   R^[x̕(PʂVWn;l͕s).̓ϐŝƂ Axis ̊Ǘp^ rsizel1QƂ( Axis Q).
:lmsg (true or false) <UDPACK>
   Ot̉}[WɃbZ[Wǂw肷. true Ȃ珑; false Ȃ珑Ȃ(l true ).
:titlesize (Float) <UDPACK>
   Ot̉}[WɏbZ[W̕(PʂVWn;l͕s).̓ϐŝƂ Axis ̊Ǘp^ rsizel1 QƂ(3.7ߎQ).
:xttl (Float) <UDPACK>
   Ot̉}[WɏbZ[Ẅʒu߂ϐ. -1  +1 ܂ł̎lƂ肤. -1 ̂Ƃ悹, 0 ̂ƂZ^O, +1 ̂ƂE悹(l 0 ).
:iundef (Fixnum) <UDPACK>
   lsł邱Ƃϐ(l -999 ).
:labelfmt (String) <UDPACK::UDSFMT>
   R^[x̃tH[}bgw肷(16ȉ). Ƃ΃R^[xׂĐ^ɂƂ 
     Contour.labelfmt = '(I8)' 
   Ƃ΂悢 (͍l߂̂Ńx8ȉȂ, Ƃ '(I12)' łʂ͓). lDCL(rbdcl)̃Tu[`CHVAL (uMISC1ṽ}jAFMTLIBQ)߂IvV'D' (L3P^łق4-5̕\)ł. 

܂Ãp^̓\bhƂėp邱ƂłBȂ킿AContour.xttl Ńp^ xttl ̎QƂAContour.xttl= Ńp^ xttl ̕ύXłB

=end

module NumRu
  module AdvancedDCL
    module Contour
      def param_init
	@param = Parameter.new(Common.param)
	@param.init("indexmj", Fixnum, "indexmj", "indexmjget", 3, 2)
	@param.init("indexmn", Fixnum, "indexmn", "indexmnget", 3, 2)
	@param.init("label", TrueClass, "udlset", "udlget", 0, 0)
	@param.init("ldash", TrueClass, "udlset", "udlget", 0, 0)
	@param.init("idash", Fixnum, "udiset", "udiget", 0, 0)
	@param.init("isolid", Fixnum, "udiset", "udiget", 0, 0)
	@param.init("icycle", Fixnum, "udiset", "udiget", 0, 0)
	@param.init("nlev", Fixnum, "udiset", "udiget", 0, 0)
	@param.init("labelsize", Float, "labelsize", "labelsizeget", 3, 2)
	@param.init("lmsg", TrueClass, "udlset", "udlget", 0, 0)
	@param.init("titlesize", Float, "titlesize", "titlesizeget", 3, 2)
	@param.init("xttl", Float, "udrset", "udrget", 0, 0)
	@param.init("iundef", Fixnum, "udiset", "udiget", 0, 0)
	@param.init("labelfmt", String, "udsfmt", "udqfmt", 1, 1)
	
	@temp_param = @param.dup
	@backup = @param.dup
      end
      
      private :param_init

#------------------- method for parameters----------------------

      def set(key, val)
	@param[key] = val
      end

# by kawanabe
=begin
---Contour.set(key, val)
    p^̐ݒsB

    
    * key:p^(String)
    * val:ݒ肷lB^͊ep^QƂ̂ƁB
    gp
        Contour.set("xttl", -1)      # bZ[W񂹂ɂB

=end

      def get(key)
	@param[key]
      end

# by kawanabe
=begin
---Contour.get(key)
    p^QƂB

    
    * key:p^(String)
    gp
        Contour.get("xttl")      # bZ[ẄʒuQƂB

=end

      def gcla(max, min, dx)
	@param.sync
	
	DCL.udgcla(max, min, dx)
      end

# by DCL manual
=begin
---Contour.gcla(max, min, dx)
    Contour.draw ŎgR^[xl ŏlEől ݒl܂͂悻̃xŐݒ肷.

    
    * max, min (Float) : R^[x̍ŏlƍől. K̂悢lłȂĂ悢.
    * dx (Float) : dx0̂Ƃ dxݕƂ. dx=0̂Ƃp^ nlev QƂ,  nlev { R^[x𐶐. dx0̂Ƃ (dx.abs.to_i) {̃R^[x𐶐. 

    l
    (1) ̃\bhUDGCLAĂł.
    (2) xminxmaxłȂ΂ȂȂ. 
    (3) R^[x dx ߂邫ݕ̐{ɂȂ悤ɐݒ肳. 
    (4) R^[ɂ郉x, DCL(rbdcl)Tu[`UDLABL. ̂ƂgptH[}bg, p^ labelfmt ɂQ/ύXł. 
    (5) R^[ɂ major line  minor line 2ނ. major line Ƃ̓xt̃R^[, minor line Ƃ̓xȂ̃R^[ł. (, p^ label  false ɂ major line xȂƂ邱Ƃł. l true ) major line ̃CCfNX̓p^ indexmj ߂(l3). major line ɕt郉x̓̕p^ rsizel ߂(PʂVWn̒l;l͕s. ̂Ƃ rsizel  Axis ̊Ǘϐ rsizel1 QƂ). minor line ̃CCfNX͓ϐ indexmn ߂(l1). 
    (6) p^ ldash  true ̂Ƃ, R^[x̃R^[C͓ϐ idash QƂẴC^Cvŕ` ( ldash ̏l true, idash ̏l3:j). ȊÕR^[C̓p^ isolid QƂẴC^Cvŕ` ( isolid ̏l1:). 
    (7) minor line  major line ̊Ԃɉ{͓ϐ icycle (l2)߂. Ȃ킿 icycle ŎQƂl1{̊ major line , c minor line . major line ̃R^[x dx Ō܂邫ݕ icycle {ɂȂ悤ɐݒ肳.

=end

      def gclb(z, dx)
	@param.sync
	
	DCL.udgclb(z, z.shape[0], z.shape[0], z.shape[1], dx)
      end

# by DCL manual
=begin
---Contour.gclb(z, dx)
    Contour.draw ŎgR^[xliq_l^zƂݒl܂͂悻̃xŐݒ肷.

    
    * z (NArray) : 2z 
    * dx (Float) : dx0̂Ƃ dxݕƂ. dx=0̂Ƃp^ nlev QƂ,  nlev { R^[x𐶐. dx0̂Ƃ (dx.abs.to_i) {̃R^[x𐶐. 

    l
    (1) ̃\bhUDGCLBĂł.
    (2) ̃[` z ̊iq_l̍ŏlEől`FbN,  Contour.gcla Ăł. 

=end

      def sclv(zlev, index, itype, clv, hl)
	@param.sync
	
	DCL.udsclv(zlev, index, itype, clv, hl)
      end

# by DCL manual
=begin
---Contour.sclv(zlev, index, itype, clv, hl)
    R^[Cׂ̑Ďw肵1{̃R^[xݒ肷.

    
    * zlev (Float) : R^[x̒l.
    * index (Fixnum) : R^[C̃CCfNX.
    * itype (Fixnum) : R^[C̃C^Cv.
    * clv (String) : R^[Cɂ郉x.
    * hl (Float) : x̍(PʂVWn). hl=0 ̂ƂxȂ.

    l
    (1) ̃\bhUDSCLVĂł.
    (2) Contour.gcla, Contour.gclb ͓ł̃\bhĂł. ⏕ꂽƂȂ Contour.gcla, Contour.gclb Ă񂾌ł̃\bhĂׂ, ׂR^[x1{ǉł. 
    (3) x(clv)̒ 8 ȉłȂ΂ȂȂ. 
    (4) ݐݒ肳ĂR^[x̑ 
         Contour.levelget
    ɂĎQƂł. 
    
=end

      def dclv(zlev)
	DCL.uddclv(zlev)
      end

# by DCL manual
=begin
---Contour.dclv(zlev)
    R^[x폜. 
 
    
    * zlev (Float) : 폜R^[x̒l.

    l
    (1) ̃\bhUDDCLVĂł.
    (2) Contour.gcla, Contour.gclb ɂĊɐݒ肳ĂR^[x̃R^[x폜Ƃ̃[`Ăׂ΂悢. 

=end

      def iclv
	DCL.udiclv
      end

# by DCL manual
=begin
---Contour.iclv
    Contour.gcla, Contour.gclb, Contour.sclv Őݒ肵R^[x𖳌ɂ. 

    
    Ȃ

    l
    (1) ̃\bhUDICLVĂł.
    (2) Contour.gcla, Contour.gclb, Contour.sclv ɂĊɐݒ肳ĂR^[x𖳌ɂ Contour.draw ĂтƂ, ̃[`ĂԕKv. 

=end

      def intervalget(nlev)
	DCL.rudlev(nlev)
      end

# by DCL manual
=begin
---Contour.intervalget(nlev)
    DGCLA, UDGCLB, UDSCLVŐݒ肵R^[x Ԋu߂. 

    
    * nlev (Fixnum) : Ԗڂ̃R^[Ԋu𒲂ׂ邩w肷.

    l
    (1) ̃\bhRUDLEVĂł.
    (2) IɂUDQCLV ɂđ nlev Ԗڂ nlev+1 Ԗڂ R^[x̒l𒲂, ̍( nlev+1 Ԗڂ nlev Ԗڂl)ԂDUDQCLVQƂR^[x̒l͕KɂȂłƂ͌ȂƂɒӂ邱.
    (3) R^[x 2 {ȏݒ肳ĂȂ΂ȂȂ. ܂ nlev  1 ȏ, ݒ肳ĂR^[x̑ 菬Ȃ΂ȂȂD̏ȂƂ RUDVAL ͌xbZ[Wo, 0 Ԃ. 

=end

      def levelget
	nlev = DCL.udqcln
	levels = []
	for i in 1..nlev
	  status = DCL.udqclv(i)
	  levels.push(status)
	end
	levels
      end
      
# by kawanabe
=begin
---Contour.levelget
    ݐݒ肳ĂR^[x̑߂B

    
    Ȃ

    l
    (1) ԂĺA[[zlev, index, itype, clv, hl], [zlev, ... ], ...] Ƃ`ArrayIuWFNgłB

=end
#----------------------------------------------------------
#------------ draw method ----------------------
      def draw(data, x=nil, y=nil, temp=nil)
	if(!(y.is_a?(Hash)))
	  if(x.is_a?(Hash))
	    temp = x.dup
	    x = nil
	  elsif(Basics.typearray(x))
	    if(!Basics.typearray(y))
	      raise ArgumentError, "both x & y must be Array or NArray(or nil)"
	    end
	  end
	else
	  raise ArgumentError, "both x & y must be Array or NArray(or nil)"
	end
	
	nx = data.shape[0]
	ny = data.shape[1]
	
	if(Basics.typearray(x) && Basics.typearray(y))
	  DCL.uwsgxa(x, x.length)
	  DCL.uwsgya(y, y.length)
	  Basics.checkundef(x, y)
	else
	  Basics.checkundef(nx.to_f, ny.to_f)
	end
	
	@param.sync
	@backup = @temp_param.set(temp, @param, @backup)
	@temp_param.sync
	
	Fig.settrf
	
	nb = DCL.glpget("nbitspw")
	nbr = (3*((nx+2)*(ny+2)*2.0/nb + 1)).ceil
	DCL.udcntz(data, nx, nx, ny, nbr)
	@backup.sync
	@temp_param.clear
      end
      
# by DCL manual
=begin
---Contour.draw(data, x=nil, y=nil, temp=nil)
    2}`

    
    * data (NArray) : 2z
    * x, y (Array or NArray) : xWAyW^z
    * temp (Hash) : e|p^

    l
    (1) ̃\bhUDCNTZĂłB
    (2) iq_̊ԊusԊȕꍇAƂx, y^ĂƎIɊiq_ݒ肷B
    (3) EBhE̐ݒsĂȂꍇɂāAx, y^΂ƂɃEBhEݒsAx, y^ȂΔz data ̊e̒ƂɃEBhEݒ肷B
    (4) R^[x̒lContour.gcla, Contour.gclb ܂ Contour.sclv ɂĐݒ肳ĂȂꍇ, ̃Tu[`ŌĂ  nlev {̃R^[xݒ肷. 
          Contour.gclb(z, -(nlev)) 
        nlev  Contour ̊Ǘp^ nlev QƂlł(l12).
    (5) R^[ASY̐񂩂, iq_̒l͂ǂ̃R^[x̒lƂĂ͂ȂȂ. ̂悤Ȋiq_lƓŔʂC (̍ۃbZ[Wo͂). 
    (6) Fig ̊Ǘp^ lmiss  true Ȃ猇lȂ. (̍, QƂ錇l Fig ̊Ǘ p^ rmiss ł. ) false Ȃ猇lȂȂ.  
    (7) R^ȎOɂׂĂ̊iq_l̃`FbNȂ. 2̏ꍇR^O͂Ȃ킸̎|bZ[Wo͂. Ƀp^ lmsg  true ̂ƂOt̉}[WɂbZ[W. false ̂ƂbZ[WȂ (l true ).2̏ꍇƂ: 
          * ׂĂ̊iq_l̂Ƃ(missing field). 
          * ׂĂ̊iq_Ȓl̂Ƃ(constant field). 
    (8) p^ lmsg  true ňׂR^[x̐2{ȏ゠Ƃ, ^̊֐RUDLEV(1) Ă 1R^[x̒l(CZL1)Ƒ2R^[x̒l(CZL2)̍ (CZL2-CZL1)Ot̉}[Wɏo. ̃bZ[W, n}eϊȊOݒ肳ĂƂ, Axis Ǘgď. , ̂悤ȏꍇ, ܂W` Contour.draw ĂԂׂł. ۂ, n}eϊݒ肳ĂƂ, }[W̐^ɏ. 

=end
      module_function :param_init
      module_function :set
      module_function :get
      module_function :draw
      module_function :gcla
      module_function :gclb
      module_function :sclv
      module_function :dclv
      module_function :iclv
      module_function :intervalget
      module_function :levelget
      
      param_init

#------------------- singleton methods ----------------------
  
      def @param.indexmj(index)
	DCL.udiset("indxmj", index)
      end

      def @temp_param.indexmj(index)
	DCL.udiset("indxmj", index)
      end
    
      def @backup.indexmj(index)
	DCL.udiset("indxmj", index)
      end

      def @param.indexmjget
	DCL.udiget("indxmj")
      end

      def @param.indexmn(index)
	DCL.udiset("indxmn", index)
      end

      def @temp_param.indexmn(index)
	DCL.udiset("indxmn", index)
      end

      def @backup.indexmn(index)
	DCL.udiset("indxmn", index)
      end

      def @param.indexmnget
	DCL.udiget("indxmn")
      end

      def @param.labelsize(size)
	DCL.udrset("rsizel", size)
      end

      def @temp_param.labelsize(size)
	DCL.udrset("rsizel", size)
      end

      def @backup.labelsize(size)
	DCL.udrset("rsizel", size)
      end

      def @param.labelsizeget
	DCL.udrget("rsizel")
      end

      def @param.titlesize(size)
	DCL.udrset("rsizet", size)
      end

      def @temp_param.titlesize(size)
	DCL.udrset("rsizet", size)
      end

      def @backup.titlesize(size)
	DCL.udrset("rsizet", size)
      end
      
      def @param.titlesizeget
	DCL.udrget("rsizet")
      end

#----------------------------------------------------------

      @param.keys.each{|i|
	eval "def #{i}; @param['#{i}']; end"
	eval "def #{i}=(val); set('#{i}', val); end"
      }
      
      @param.keys.each{|i|
	eval "module_function :#{i}"
	eval "module_function :#{i}="
      }
    end
  end
end
