# INSTALL GUIDE                                                      {#INSTALL}
@ja
## 必要要件

gtool5 ライブラリを利用するには以下のソフトウェアが必要です.
@endja
@en
## Prerequisite
@enden

* Fortran Compiler (Support >= F2003 standard)
* [Unidata | NetCDF C Library](http://www.unidata.ucar.edu/software/netcdf/)
* [Unidata | NetCDF Fortran Library](http://www.unidata.ucar.edu/downloads/netcdf/index.jsp)
* [Doxygen](http://www.stack.nl/~dimitri/doxygen/)

@ja
## ビルドの手引き
@endja
@en
## How to build
@enden
@ja
### tar.gz 展開

適当な作業ディレクトリでソースアーカイブを展開します.
ソースは gtool5-((|バージョン|)) というディレクトリに展開されます.

	$ tar xvf gtool5_current.tar.gz

@endja
@en
### Extract tar.gz

Make an empty directory, and extract archive.
A directory `gtool5-((|version|))'
created at the current working directory.

	$ tar xvf gtool5_current.tar.gz
@enden
@ja
### Fortran コンパイラの指定

環境変数 ((* FC *)) に使用する Fortran コンパイラを指定してください.
例えば

    % FC=gfortran

最適化やデバッグのためのオプションは環境変数 ((* FCFLAGS *)) に設定してください.
例えば

    % FCFLAGS="-g -O2 -fopenmp"

@endja
@en
### Specify Fortran Compiler

Specify Fortran compiler to environment variable ((* FC *)), e.g.

    % FC=gfortran

Specify Fortran compiler options for optimization and debug to
environment variable ((* FCFLAGS *)), e.g.,

    % FCFLAGS="-g -O2 -fopenmp"

@enden
@ja
### configure の実行

展開されたディレクトリに移動し, (({ ./configure }))を実行します.

    % ./configure

インストール先などを変更したい場合は, 以下のように (({ --help })) オプ
ションをつけることで, 指定可能なオプションリストが表示されます.

	% ./configure --help

主なオプションに関しての説明は以下の通りです.

:(({--with-nf-config=}))((|ARG|))
  * Defatult: PATH から探索.
  * ((|ARG|)) に ((:nf-config:)) を明示的に指定することもできます.
    これによって NetCDF C Library および NetCDF Fortran Library に関する
    設定が行なわれます.

:(({--with-netcdf=}))((|ARG|))
  * ((:nf-config:)) が使えない場合に NetCDF C Library の場所を指定します.

:(({--with-netcdff=}))((|ARG|))
  * ((:nf-config:)) が使えない場合に NetCDF Fortran Library の場所を指定します.

:(({--with-netcdf-include=}))((|ARG|))
  * ((:nf-config:)) が使えない場合に NetCDF Fortran Library の
    モジュールファイル((:netcdf.mod:)) 場所を指定します.

:(({--with-netcdf-include=}))((|ARG|))
  * ((:nf-config:)) が使えない場合に NetCDF Fortran Library の
    モジュールファイル((:netcdf.mod:)) 場所を指定します.

:(({--prefix=}))((|ARG|))
  * Defatult: (({ /usr/local/gtool5 }))
  * ((|ARG|)) にライブラリやモジュール, 実行ファイルのインストール先の
    ディレクトリのプレフィックスを指定します.

:(({--host=}))((|ARG|))
  クロスコンパイルを行う場合には, パッケージが実行されるシステムタイプ名
  を ((|ARG|)) に指定します.

:(({--enable-mpi}))
  * Defatult: enabled
  * MPI を有効にします. ((:FC:)) に
    MPI 用のコンパイラ(例えば mpif90 等)を指定して下さい.

:(({--with-mpiexec}))
  * Defatult: none
  * テスト時に使用する MPI 実行プログラムを指定します.

:(({--with-ncdump}))
  * Defatult: PATH から探索
  * テスト時に使用する ncdump を指定します.

@endja
@en
### Execute configure

Move created directroy, and excute `(({ ./configure }))'.

    % ./configure

If you want to change directory to which the library and the module, etc.
are installed, please set (({ --help })) option as follow. Available
options are showed.

	% ./configure --help

Descriptions about principal options are listed below.

:(({--with-nf-config=}))((|ARG|))
  * Default: search ((:nf-config:)) from ((:PATH:)).
  * If you want to use another ((:nf-config:)),
    set the location of ((:nf-config:)) to ((|ARG|)) explicitly.

:(({--with-netcdf=}))((|ARG|))
  * When you can't execute ((:nf-config:)),
    set the location of NetCDF C Library to ((|ARG|)) explicitly.

:(({--with-netcdff=}))((|ARG|))
  * When you can't execute ((:nf-config:)),
    set the location of NetCDF Fortran library to ((|ARG|)) explicitly.

:(({--with-netcdf-include=}))((|ARG|))
  * When you can't execute ((:nf-config:)),
    set the location of module file ((:netcdf.mod:)) to ((|ARG|)) explicitly.

:(({--prefix=}))((|ARG|))
  * Default: (({ /usr/local/gtool5 })).
    set prefix to ((|ARG|)).

:(({--host=}))((|ARG|))
  * When cross-compiling,
    set the type of system on which the package will run to ((|ARG|)).

:(({--enable-mpi}))
  * Default: enable
  * Enable MPI support.
    Set MPI Fortran Compiler to ((:FC:)), e.g. mpif90.

:(({--with-mpiexec}))
  * Default: none
  * Set MPI execute program for test.

:(({--with-ncdump}))
  * Default: search ((:ncdump:)) from ((:PATH:)).
  * Set ((:ncdump:)) for test.


@enden
@ja
### ビルド
((:configure:)) が正常に終了したならば

    % make

でビルドが始まります.

@endja
@en
### Compile source code
After execute ((:configure:)), start build processes as

    % make

@enden
@ja
## テストプログラム実行

カレントディレクトリにおいて, 以下のコマンドを実行してください.

	$ make test

@endja
@en
## Execute test programs

In current directry, execute following command.

	$ make test

@enden
@ja
## インストール

カレントディレクトリで以下のコマンドを実行してください.
システム領域にインストールする場合には管理者権限が
必要です. (デフォルトの場合はシステム領域にインストールします).

	# make install

@endja
@en
## Install

In current directory, execute following command.
If you install to system, you need to be administrator.
(By default, you install to system).

	# make install

@enden
@ja
## gt5frt へのパスの設定

上記のように正しくインストールが行われたら,
((*gt5frt*)) というシェルスクリプトが (({--prefix=}))((|ARG|))
で指定されたディレクトリ以下の bin ディレクトリ ((|ARG|))/bin
に作成されているはずです.
( (({--prefix=})) を指定しなかった場合は
(({ /usr/local/gtool5/bin/ })) 以下).
このディレクトリへのパスを通してください.

((*gt5frt*)) は gtool5 ライブラリを利用した Fortran プログラムを
簡単にコンパイル, リンクするためのシェルスクリプトです.
これまで利用していた Fortran コンパイラのコマンドの代わりに
gt5frt を用いることで, 自動的に gtool5 ライブラリへの
リンク, モジュール群へのディレクトリ指定を行ってくれます.

	$ gt5frt test.f90
    /usr/bin/gfortran -I/usr/local/gtool5/include -I/usr/include -g -O2 test.f90 \
      -L/usr/local/stow/gtool5/lib -lgtool -L/usr/lib -lnetcdff -lnetcdf

@endja
@en
## Set PATH to gt5frt

If the installation is correctly done as stated above,
shell script ((*gt5frt*)) is made under the directory
(({--prefix=}))((|ARG|))/bin
(By default, (({ /usr/local/gtool5/bin/ })) ).

Please specify PATH to this directory.
It is an example as follows when ((*gt5frt*)) is installed in
(({/usr/local/gtool5/bin/})) .

((*gt5frt*)) is a shell script in order to easily compile and link
Fortran programs which utilizes the gtool5 library.
Link to the gtool5 library and directory appointment to the modules
are done automatically by using gt5frt in place of command of the
Fortran compiler.

	$ gt5frt test.f90
    /usr/bin/gfortran -I/usr/local/gtool5/include -I/usr/include -g -O2 test.f90 \
      -L/usr/local/stow/gtool5/lib -lgtool -L/usr/lib -lnetcdff -lnetcdf


@enden
