! netcdf_filename.f90 - object-oriented netCDF file interface (filename)
! vi: set sw=4:
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
!
! 2000-01-12 ˭ıѻ	
! 2000-01-16 ˭ıѻ	ϥå
! 2000-02-22 ˭ıѻ	Ĺʸ

module netcdf_filename
    use iso_varying_string
    implicit none

    private
    public:: NetcdfSaveFilename, NetcdfIdToFilename
    public:: NetcdfDisableFileId
    public:: NC_FILENAME_MAX

    integer, parameter:: NC_FILENAME_MAX = 252
    integer, parameter:: INITIAL_TABLE_SIZE = 16

    type TableEntry
    	integer::			id
	type(VARYING_STRING)::		name
    end type

    type(TableEntry), save, pointer::	Table(:)

contains

    integer function lookupId(id)
	integer, intent(in)::		id
	integer::			i
    continue
	do, i = 1, size(Table)
	    if (Table(i)%id == id) then
		lookupId = i
		return
	    endif
	enddo
	lookupId = -1
    end function

    function initTable()
	logical::		initTable
	integer::		status
    continue
	initTable = .true.
	if (associated(Table)) return
	allocate(Table(INITIAL_TABLE_SIZE), stat=status)
	if (status == 0) then
	    Table%id = -1
	else
	    initTable = .false.
	endif
    end function

    subroutine growTable(newsize)
	integer, intent(in)::		newsize
	integer::			copysize, status
	type(TableEntry), pointer::	newtable(:)
    continue
	copysize = min(size(Table), newsize)
	allocate(newtable(newsize), stat=status)
	if (status == 0) then
	    newtable(1:copysize) = Table(1:copysize)
	    newtable(copysize+1:)%id = -1
	    deallocate(Table)
	    Table => newtable
	endif
    end subroutine

    subroutine NetcdfDisableFileId(id)
	integer, intent(in)::		id
	integer::			i
    continue
	i = lookupId(id)
	Table(i)%id = -1
    end subroutine

    type(VARYING_STRING) function NetcdfIdToFilename(id)
	integer, intent(in)::		id
	integer::			i
    continue
	i = lookupId(id)
	NetcdfIdToFilename = Table(i)%name
    end function

    subroutine NetcdfSaveFilename(id, name)
	integer, intent(in)::		id
	character(len=*), intent(in)::	name
	integer::			i
    continue
	if (.not. initTable()) return
	i = lookupId(id)
	if (i /= -1) then
	    Table(i)%name = name
	    return
	endif
	i = lookupId(-1)
	if (i /= -1) then
	    Table(i)%id = id
	    Table(i)%name = name
	    return
	endif
	call growTable(size(Table) * 2)
	i = lookupId(-1)
	if (i /= -1) then
	    Table(i)%id = id
	    Table(i)%name = name
	endif
    end subroutine

end module netcdf_filename
