!== dc_date_types#DC_DATETIME, dc_date_types#DC_DIFFTIME ΰ
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcdatetimeputline.f90,v 1.3 2008/02/11 14:30:52 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080211 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե󶡤³ dc_date ⥸塼ˤ󶡤ޤ
!

subroutine DCDateTimePutLine(time, unit)
  !
  ! dc_date_types#DC_DATETIME ѿΰԤޤ. *unit* 
  ! ˤϽֹ
  ! ͿƤ. *unit* Ϳʤ, ɸϤɽޤ.
  !
  use dc_date_types, only: DC_DATETIME
  use dc_date, only: toChar
  use dc_string, only: Printf
  use dc_trace, only: BeginSub, EndSub
  use dc_types, only: STDOUT
  implicit none
  type(DC_DATETIME), intent(in) :: time
  integer, intent(in), optional :: unit

  integer :: out_unit
  character(*), parameter :: subname = 'DCDateTimePutLine'
continue
  call BeginSub(subname)
  if (present(unit)) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  call Printf(out_unit, &
    & '#<DC_DATETIME:: @date=%c @day=%d @sec=%f @caltype=%d @zone=%c>', &
    & i=(/time % day, time % caltype/), d=(/time % sec/), &
    & c1=trim(toChar(time)), c2=trim(time % zone))
999 continue
  call EndSub(subname)
end subroutine DCDateTimePutLine

subroutine DCDiffTimePutLine(diff, unit)
  !
  ! dc_date_types#DC_DIFFTIME ѿΰԤޤ. *unit* 
  ! ˤϽֹ
  ! ͿƤ. *unit* Ϳʤ, ɸϤɽޤ.
  !
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: toChar
  use dc_string, only: Printf
  use dc_trace, only: BeginSub, EndSub
  use dc_types, only: STDOUT
  implicit none
  type(DC_DIFFTIME), intent(in) :: diff
  integer, intent(in), optional :: unit

  integer :: out_unit
  character(*), parameter :: subname = 'DCDiffTimePutLine'
continue
  call BeginSub(subname)
  if (present(unit)) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  call Printf(out_unit, &
    & '#<DC_DIFFTIME:: @diff=%c @mon=%d @day=%d @sec=%f>', &
    & i=(/diff % mon, diff % day/), d=(/diff % sec/), &
    & c1=trim(toChar(diff)))
999 continue
  call EndSub(subname)
end subroutine DCDiffTimePutLine


!-----------------------------------------------
! ߴ
! For backward compatibility
subroutine DCDateTimePutLine_bc(time, unit)
  use dc_date_types, only: DC_DATETIME
  use dc_date, only: DCDateTimePutLine
  type(DC_DATETIME), intent(in) :: time
  integer, intent(in), optional :: unit
continue
  call DCDateTimePutLine( time, unit )
end subroutine DCDateTimePutLine_bc

subroutine DCDiffTimePutLine_bc(diff, unit)
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: DCDiffTimePutLine
  type(DC_DIFFTIME), intent(in) :: diff
  integer, intent(in), optional :: unit
continue
  call DCDiffTimePutLine( diff, unit )
end subroutine DCDiffTimePutLine_bc
