!== Command line arguments parser
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dc_args.f90,v 1.13 2008/02/11 17:30:39 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20080211 $
! Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module dc_args
  !
  !== Overview
  !
  ! ޥɥ饤βϤԤޤ.
  !
  ! ä, إץåɽ˴ؤʥ֥롼
  ! ѰդƤޤ.
  !
  !== List
  !
  ! DCArgsOpen     :: ¤ ARGS ѿν
  ! DCArgsClose    :: ¤ ARGS ѿνλ
  ! DCArgsGet      :: ޥɥ饤μ
  ! DCArgsNumber   :: ޥɥ饤ο֤
  ! DCArgsOption   :: ޥɥ饤ץ뤿
  ! DCArgsDebug    :: ǥХåץμư
  ! DCArgsHelp     :: إץץμư
  ! DCArgsHelpMsg  :: إץå
  ! DCArgsStrict   :: ̵ʥץ󤬻ꤵ줿˷ٹɽ褦
  ! DCArgsPutLine  :: ¤ ARGS ѿƤ
  !
  !
  !== Usage
  !
  ! ¤ ARGS ѿ, Open, Get Ѥ뤳Ȥ
  ! ޥɥ饤뤳ȤǤޤ.
  !
  !       use dc_types
  !       use dc_string, only: StoA
  !       use dc_args
  !       implicit none
  !       type(ARGS) :: arg
  !       character(STRING), pointer :: argv(:) => null()
  !       integer :: i
  !
  !       call DCArgsOpen( arg = arg )   ! (out)
  !       call DCArgsDebug( arg = arg )  ! (inout)
  !       call DCArgsHelp( arg = arg )   ! (inout)
  !       call DCArgsStrict( arg = arg ) ! (inout)
  !       call DCArgsGet( arg = arg, &   ! (inout)
  !         & argv = argv )              ! (out)
  !       do i = 1, size( argv )
  !         write(*,*) argv(i)
  !       end do
  !       deallocate( argv )
  !       call DCArgsClose( arg = arg )  ! (inout)
  !
  ! ˥ץꤷˤ, DCArgsOption ֥롼
  ! ѤƤ. ץν񼰤˴ؤƤ DCArgsOption 
  ! ֥ץν񼰡פ򻲾ȤƤ.
  !
  !       use dc_types
  !       use dc_string, only: StoA
  !       use dc_args
  !       implicit none
  !       type(ARGS) :: arg
  !       logical :: OPT_size
  !       logical :: OPT_namelist
  !       character(STRING) :: VAL_namelist
  !
  !       call DCArgsOpen( arg = arg ) ! (inout)
  !       call DCArgsOption( arg = arg, &           ! (inout)
  !         & options = StoA('-s', '--size'), &     ! (in)
  !         & flag = OPT_size, &                    ! (out)
  !         & help = "Return number of arguments")  ! (in)
  !       call DCArgsOption( arg = arg, &           ! (inout)
  !         & options = StoA('-N', '--namelist'), & ! (in)
  !         & flag = OPT_namelist, &                ! (out)
  !         & value = VAL_namelist, &               ! (out)
  !         & help = "Namelist filename")           ! (in)
  !
  !       call DCArgsDebug( arg = arg )  ! (inout)
  !       call DCArgsHelp( arg = arg )   ! (inout)
  !       call DCArgsStrict( arg = arg ) ! (inout)
  !
  !       if (OPT_size) then
  !         write(*,*) 'number of arguments :: ', DCArgsNumber(arg)
  !       end if
  !       if (OPT_namelist) then
  !         write(*,*) '--namelist=', trim(VAL_namelist)
  !       else
  !         write(*,*) '--namelist is not found'
  !       end if
  !       call DCArgsClose( arg = arg ) ! (inout)
  !
  ! ޥɥ饤 '-h', '-H', '--help' ΤŤ줫Υץ
  ! ꤹ뤳Ȥ, ץΰɸϤɽޤ.
  !
  ! إץåƤ򽼼¤ˤ HelpMsg 
  ! ȤƤ.
  !
  !
  !== Note
  !
  !=== ߴ
  !
  ! С 20071009 Ѳǽäʲμ³, 
  ! ߴΤ, Ф餯ѲǽǤ. 
  ! 
  ! * Open, Close, Option, PutLine, Debug, Help, HelpMsg, Strict, Get
  !   Number
  !
  !=== dc_args ⥸塼ͳˤĤ
  !
  ! Fortran ѥΤۤȤɤˤ IARGC, GETARG Ȥä
  ! ޥɥ饤ΤץबѰդƤ.
  ! ץѤˤä, ޥɥ饤ΰ
  ! ñ˼뤳ȤϴñǤ.
  !
  !  IARGC, GETARG λѤ˺ݤ, 2 Ĥۤݤ.
  !
  ! 1 Ĥϥѥ¸ˤ IARGC, GETARG λͤΰ㤤Ǥ.
  ! ץ Fortran ʤ˴ޤޤʤӥ롼
  ! Ǥ뤿, ƤΥѥˤϤץ
  ! ¸ߤΤ, ̯ͤ˰ۤʤ礬. (Υѥ
  ! GETARG  1 ˤȰܤΰ뤬, 
  ! Ť HITACHI Υѥ 2 ˤʤȰܤ
  ! Ǥʤ, ʤ).  gt4f90io 饤֥Ǥ
  ! Υѥ¸ۼ߷פԤäƤ.
  ! dc_args ⥸塼Ѥݤˤ, Υѥ¸
  ! ˤʤƤ褤. (ʤ, ѥ¸ºݤ
  ! ۼƤΤ sysdep ⥸塼Ǥ).
  !
  ! 2 ܤ, ޥɥ饤ˤ륪ץ
  ! (-h  --version ʤ) μ갷ؤǤ.
  ! IARGC  GETARG ñ˰뤿ץǤ,
  ! Perl  Ruby ʤɤΥ󥿥ץ꥿Τ褦,
  ! ޥɥ饤˥ץ뤿
  ! 饤֥ (Getopt  OptionParser ʤ) ѰդƤʤ.
  ! dc_args ⥸塼, Fortran ץǤ⥪ץ
  ! ڤ˰褦, ץ
  ! Υǥ󥰤ǤǤˤ٤ץǤ.
  !
  ! ߷׻ۤ, {֥Ȼظץȸ Ruby}[http://www.ruby-lang.org/]
  !  OptionParser[http://www.ruby-lang.org/ja/man/index.cgi?cmd=view;name=OptionParser]
  ! 򿿻Ƥ, OptionParser 饹Υ֥Ȥ
  ! ¤ ARGS , new (initialize) ᥽åɤ DCArgsOpen ֥롼,
  ! on ᥽åɤ DCArgsOption ֥롼, parse ᥽åɤ DCArgsGet
  ! ֥롼˸ΩƤƤ. ͤΰ㤤ˤͤ
  ! ʤ˰ۤʤ뤬, ¤ ARGS ѿ򥪥֥Ȥ˸Ω,
  ! ѿФƥ֥롼Ѥ뤳Ȥˤä
  ! ֥Ȥؤ䥪֥ȤΰμԤȤǤ
  ! OptionParser ƱͤǤ.
  !
  ! ޤŪǽǤ뤬, dc_trace ⥸塼ȤϢȤޤƤ,
  ! Debug ֥롼Ѥ뤳Ȥˤ (ˡϾ嵭), ƥ
  ! ѥ뤹뤳Ȥʤ, ץμ¹Ԥκݤ "-D" ץĤ
  ! ȤǥǥХååɽ⡼ɤѹ뤳ȤǤ.
  !

  use dc_types, only : STRING
  use dc_hash, only: HASH
  implicit none
  private

  public:: ARGS
  public:: DCArgsOpen, DCArgsClose, DCArgsOption
  public:: DCArgsPutLine, DCArgsDebug, DCArgsHelp
  public:: DCArgsHelpMsg, DCArgsStrict, DCArgsGet
  public:: DCArgsNumber

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  public:: Open, Close, Option, PutLine, Debug, Help, HelpMsg, Strict, Get
  public:: Number

  type ARGS
    !
    ! ޥɥ饤Ѥι¤ΤǤ.
    ! ˤ DCArgsOpen , λˤ DCArgsClose Ѥޤ.
    ! ޥɥ饤Ϳ, ץ 
    ! DCArgsOption, DCArgsHelpMsg ֥롼ˤäͿ줿
    ! Ǽޤ.
    !
    ! ܤȤ dc_args  Usage 򻲾Ȥ.
    !
    private
    type(OPT_ENTRY), pointer :: opt_table(:) => null()
                              ! DCArgsOption ֥롼ǻꤵ
                              ! ץΥꥹ
    logical :: initialized = .false.
    type(CMD_OPTS_INTERNAL), pointer :: cmd_opts_list(:) => null()
                              ! ޥɥ饤Τ, ץ
                              ! Ƽ̤ΤΤΥꥹ.
    type(HASH) :: helpmsg
  end type ARGS

  type OPT_ENTRY
    character(STRING), pointer:: options(:) => null()
                              ! ץ̾ꥹ
    character(STRING) :: help_message
                              ! إץå
    logical :: optvalue_flag
                              ! ץ̵ͤͭ
  end type OPT_ENTRY

  type CMD_OPTS_INTERNAL
    character(STRING) :: name  ! ץ̾
    character(STRING) :: value ! 
    logical:: flag_called = .false.
                              ! Υץ̾ DCArgsOption ǸƤФ줿
                              ! ɤȽ̤ե饰
  end type CMD_OPTS_INTERNAL

  interface DCArgsOpen
    module procedure DCArgsOpen
  end interface

  interface DCArgsClose
    module procedure DCArgsClose
  end interface

  interface DCArgsOption
    module procedure DCArgsOption
  end interface

  interface DCArgsPutLine
    module procedure DCArgsPutLine
  end interface

  interface DCArgsDebug
    module procedure DCArgsDebug
  end interface

  interface DCArgsHelp
    module procedure DCArgsHelp
  end interface

  interface DCArgsHelpMsg
    module procedure DCArgsHelpMsg
  end interface

  interface DCArgsStrict
    module procedure DCArgsStrict
  end interface

  interface DCArgsGet
    module procedure DCArgsGet
  end interface

  interface DCArgsNumber
    module procedure DCArgsNumber
  end interface

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  interface Open
    module procedure DCArgsOpen
  end interface

  interface Close
    module procedure DCArgsClose
  end interface

  interface Option
    module procedure DCArgsOption
  end interface

  interface PutLine
    module procedure DCArgsPutLine
  end interface

  interface Debug
    module procedure DCArgsDebug
  end interface

  interface Help
    module procedure DCArgsHelp
  end interface

  interface HelpMsg
    module procedure DCArgsHelpMsg
  end interface

  interface Strict
    module procedure DCArgsStrict
  end interface

  interface Get
    module procedure DCArgsGet
  end interface

  interface Number
    module procedure DCArgsNumber
  end interface


  !-------------------------------------
  ! BuildArgTable ꤵѿ
  character(STRING), allocatable, save:: argstr_table(:)
                              ! . (ץ󤫤ɤʤ
                              ! Ƚ̤ϹԤäƤʤ). BuildArgTable
                              ! ꤵ.

  integer, save:: argind_count = -1
                              ! ο. BuildArgTable 
                              ! ꤵ.

  !-------------------------------------
  ! SortArgTable ꤵѿ
  type(CMD_OPTS_INTERNAL), allocatable, save :: cmd_opts_list(:)
                              ! ޥɥ饤Τ, ץ
                              ! Ƽ̤ΤΤΥꥹ
                              ! . SortArgTable ꤵ.

  character(STRING), allocatable, save:: cmd_argv_list(:)
                              ! ޥɥ饤Τ, ץ
                              ! ϤʤΥꥹ. SortArgTable 
                              ! ꤵ.

contains

  subroutine DCArgsOpen(arg)
    !
    ! ARGS ѿꤷޤ. 
    !
    ! ARGS ѿѤݤˤϤޤΥ֥롼ˤä
    ! ԤäƤ.
    !
    ! Υ֥롼, 겼ؤΥ֥롼 IARGC  GETARG
    ! Ѥ줿ޥɥ饤ξ *arg*
    ! ؤȳǼޤ.
    !
    use dc_message, only: MessageNotify
    use dc_types, only: STRING
    implicit none
    type(ARGS), intent(out) :: arg
    integer:: cmd_opts_max
    character(len = *), parameter :: subname = 'DCArgsOpen'
  continue
    if (arg % initialized) then
      call MessageNotify('W', subname, 'This argument (type ARGS) is already opend.')
      return
    end if
    call BuildArgTable
    call SortArgTable
    cmd_opts_max = size(cmd_opts_list)
    allocate(arg % cmd_opts_list(cmd_opts_max))
    arg % cmd_opts_list = cmd_opts_list
    allocate(arg % opt_table(0))
    arg % initialized = .true.
  end subroutine DCArgsOpen

  subroutine DCArgsClose(arg)
    !
    ! ARGS ѿνλԤޤ. 
    !
    use dc_hash, only: DCHashDelete
    implicit none
    type(ARGS), intent(inout) :: arg
    integer :: i
  continue
    if (arg % initialized) then
       do i = 1, size(arg % opt_table)
        deallocate(arg % opt_table(i) % options)
      end do

      deallocate(arg % opt_table)
      deallocate(arg % cmd_opts_list)
      call DCHashDelete(arg % helpmsg)
    end if
  end subroutine DCArgsClose

  subroutine DCArgsOption(arg, options, flag, value, help)
    !
    ! ץϿȼԤޤ. 
    !
    ! ޥɥ饤Τ, *options* Ϳ륪ץ˴ؤ
    !  *flag*  *value* ˼ޤ. *options* ޥɥ饤
    ! ͿƤ *flag*  .true. , Ǥʤ 
    ! .false. ֤ޤ. ץͤꤵ *value* 
    ! ֤ͤޤ. ץΤͿƤʤˤ
    ! *value* ˤ϶ʸ֤ޤ.
    !
    ! *help* ˤ *options* ˴ؤإץå *arg* 
    ! Ͽޤ. ֥롼 DCArgsHelp 
    ! Ѥݤ, ΥåϤޤ.
    ! *value* ͿƤ뤫ɤǤΥåѲޤ.
    !
    !=== ץν
    !
    ! ޥɥ饤Τ, ץȽꤵΤϰʲξǤ.
    !
    ! * 1 ʸܤ '-' ξ. ξûץȤʤ, '-'
    !   μΰʸΤߤץȤͭˤʤޤ.
    !
    ! * 1-2ʸܤ '--' (ϥե 2 ʸ) ξ.
    !   ξĹץȤʤ,
    !   '--' ʹߤʸ󤬥ץȤͭˤʤޤ.
    !
    ! ץͤ, "=" ʸˤʤޤ.
    !
    ! 
    !
    ! <b>ޥɥ饤</b>  :: <b>ץ̾,       </b>
    ! -h                         ::    -h,           ̵
    ! --help                     ::    --help,       ̵
    ! -D=6                       ::    -D,            6
    ! -debug=                    ::    -d,           ̵
    ! --include=/usr             ::    --include,    /usr
    !

    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(len = *), intent(in) :: options(:)
    logical, intent(out) :: flag
    character(len = *), intent(out), optional :: value
    character(len = *), intent(in), optional :: help
    integer :: i, j, options_size, table_size
    type(OPT_ENTRY), allocatable :: local_tables(:)
    character(len = STRING) :: opt_name, opt_value, opt_full
    character(len = *), parameter  :: subname = 'DCArgsOption'
  continue
    flag = .false.
    if (present(value)) value = ''
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Option in dc_args.')
      call DCArgsOpen(arg)
    end if
    options_size = size(options)
    if (options_size < 1) then
      return
    end if

    !-----------------------------------
    ! ¤ ARGS ؤΥإץåѤξϿ
    ! * ޤϥơ֥ arg % opt_table Ĺ.
    !-----------------------------------
    table_size = size(arg % opt_table)
    allocate(local_tables(table_size))
    local_tables(1:table_size) = arg % opt_table(1:table_size)
    deallocate(arg % opt_table)
    allocate(arg % opt_table(table_size + 1))
    arg % opt_table(1:table_size) = local_tables(1:table_size)
    deallocate(local_tables)
    !----- ͤ -----
    allocate(arg % opt_table(table_size + 1) % options(options_size))
    arg % opt_table(table_size + 1) % options = options
    arg % opt_table(table_size + 1) % help_message = ''
    if (present(help)) then
      arg % opt_table(table_size + 1) % help_message = help
    end if
    arg % opt_table(table_size + 1) % optvalue_flag = present(value)

    !----- options  -----
    do i = 1, options_size
      opt_full = arg % opt_table(table_size + 1) % options(i)
      if (DCOptionFormC(opt_full, opt_name, opt_value)) then
        arg % opt_table(table_size + 1) % options(i) = opt_name
      else
        if (len(trim(adjustl(opt_full))) < 2) then
          arg % opt_table(table_size + 1) % options(i) = &
            & '-' // trim(adjustl(opt_full))
        else
          arg % opt_table(table_size + 1) % options(i) = &
            & '--' // trim(adjustl(opt_full))
        end if
      end if
    end do

    ! arg % cmd_opts_list õ flag, value ؤ
    ! ƤФ줿Τ˴ؤƤ arg % cmd_opts_list % flag_called 
    ! .true. 
    do i = 1, options_size
      do j = 1, size(arg % cmd_opts_list)
        if (trim(arg % opt_table(table_size + 1) % options(i)) &
          &             == trim(arg % cmd_opts_list(j) % name)) then
          flag = .true.
          if (present(value)) then
            value = arg % cmd_opts_list(j) % value
          end if
          arg % cmd_opts_list(j) % flag_called = .true.
        end if
      end do
    end do
  end subroutine DCArgsOption

  subroutine DCArgsDebug(arg)
    !
    ! ǥХåץμưԤޤ. 
    !
    ! -D ⤷ --debug ꤵ줿, ưŪ
    ! dc_trace#SetDebug ƤӽФ褦 *arg* ꤷޤ.
    !
    use dc_types, only: STRING
    use dc_string, only: StoA, StoI
    use dc_trace, only: SetDebug
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    logical :: OPT_debug
    character(STRING) :: VAL_debug
    character(len = *), parameter  :: subname = 'DCArgsDebug'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Debug in dc_args.')
      call DCArgsOpen(arg)
    end if
    call Option(arg, StoA('-D', '--debug'), OPT_debug, VAL_debug, &
      & help="call dc_trace#SetDebug (display a lot of messages for debug). " // &
      & "VAL is unit number (default is standard output)")
    if (OPT_debug) then
      if (trim(VAL_debug) == '') then
        call SetDebug
      else
        call SetDebug(StoI(VAL_debug))
      end if
    end if
    return
  end subroutine DCArgsDebug


  subroutine DCArgsHelp(arg, force)
    !
    ! إץץμưԤޤ. 
    !
    ! -h, -H, --help ΤŤ줫ꤵ줿, ưŪ *arg* ꤵ줿
    ! إץåȤɽ, ץλޤ.
    ! §Ū, Υ֥롼 DCArgsOption, DCArgsDebug 
    ! Υ֥롼Ƥǲ.
    !
    ! *force*  .true. ꤵ, -H, --help ץͿ
    ! ʤǤإץåɽ, ץλ
    ! ޤ.
    !
    ! إץåɽ, DCArgsOption, DCArgsHelpMsg
    ! ֥롼ˤäղä뤳ȤǽǤ.
    !
    use dc_types, only: STRING, STDOUT
    use dc_string, only: StoA, StoI, Printf, Concat, JoinChar, UChar, LChar
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    use dc_hash, only: DCHashGet, DCHashDelete, DCHashRewind, DCHashNext
    implicit none
    type(ARGS), intent(inout) :: arg
    logical, intent(in), optional :: force
    logical :: OPT_help, found, end
    character(STRING) :: VAL_help, options_msg, help_msg, category
    character(STRING), pointer :: localopts(:) => null()
    integer :: unit, i
    character(len = *), parameter  :: subname = 'DCArgsHelp'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    call DCArgsOption(arg, StoA('-h', '-H', '--help'), OPT_help, VAL_help, &
      & help="display this help and exit. " // &
      & "VAL is unit number (default is standard output)")
    if (.not. OPT_help .and. .not. present_and_true(force)) then
      return
    end if
    if (trim(VAL_help) == '') then
      unit = STDOUT
    else
      unit = StoI(VAL_help)
    end if

    call Printf(unit, '')

    call DCHashGet(arg % helpmsg, 'TITLE', help_msg, found)
    if (found) then
      call Printf(unit, '%c', c1=trim(help_msg))
      call Printf(unit, '')
      call DCHashDelete(arg % helpmsg, 'TITLE')
    end if

    call DCHashGet(arg % helpmsg, 'OVERVIEW', help_msg, found)
    if (found) then
      call Printf(unit, 'Overview::')
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')
      call DCHashDelete(arg % helpmsg, 'OVERVIEW')
    end if

    call DCHashGet(arg % helpmsg, 'USAGE', help_msg, found)
    if (found) then
      call Printf(unit, 'Usage::')
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')
      call DCHashDelete(arg % helpmsg, 'USAGE')
    end if

    call Printf(unit, 'Options::')
    do i = 1, size(arg % opt_table)
      options_msg = ' '
      if (arg % opt_table(i) % optvalue_flag) then
        call Concat(arg % opt_table(i) % options, '=VAL', localopts)
      else
        allocate(localopts(size(arg % opt_table(i) % options)))
        localopts = arg % opt_table(i) % options
      end if
      options_msg = trim(options_msg) // trim(JoinChar(localopts))
      deallocate(localopts)
      call Printf(unit, ' %c', c1=trim(options_msg))
      call PrintAutoLinefeed(unit, &
        & arg % opt_table(i) % help_message, indent='     ')
      call Printf(unit, '')
    end do

    call DCHashRewind(arg % helpmsg)
    do
      call DCHashNext(arg % helpmsg, category, help_msg, end)
      if (end) exit

      call Printf(unit, '%c%c::', &
        & c1=trim(UChar(category(1:1))), c2=trim(LChar(category(2:))))
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')

    enddo

    call DCArgsClose(arg)

    stop
  end subroutine DCArgsHelp

  subroutine DCArgsHelpMsg(arg, category, msg)
    !
    ! إץåɲäޤ. 
    !
    ! ֥롼 DCArgsHelp Ѥݤ˽Ϥå
    ! ղäޤ. *category*  +Title+, +Overview+, +Usage+ 
    ! ꤵ줿Τ +Options+ ,
    ! ʳΤΤϲɽޤ.
    ! *msg* ˤϥåͿƤ.
    !
    !=== 
    !
    !       use dc_types
    !       use dc_string, only: StoA
    !       use dc_args
    !       implicit none
    !       type(ARGS) :: arg
    !       logical :: OPT_namelist
    !       character(STRING) :: VAL_namelist
    !       character(STRING), pointer :: argv(:) => null()
    !       integer :: i
    !
    !       call DCArgsOpen( arg = arg )   ! (out)
    !       call DCArgsHelpMsg( arg = arg, &              ! (inout)
    !         & category = 'Title', &                     ! (in)
    !         & msg = 'dcargs $Revision: 1.13 $ ' // &
    !         &       ':: Test program of dc_args' )      ! (in)
    !       call DCArgsHelpMsg( arg = arg, &              ! (inout)
    !         & category = 'Usage', &                     ! (in)
    !         & msg = 'dcargs [Options] arg1, arg2, ...') ! (in)
    !       call DCArgsOption( arg = arg, &           ! (inout)
    !         & options = StoA('-N', '--namelist'), & ! (in)
    !         & flag = OPT_namelist, &                ! (out)
    !         & value = VAL_namelist, &               ! (out)
    !         & help = "Namelist filename")           ! (in)
    !       call DCArgsHelpMsg( arg = arg, &          ! (inout)
    !         & category = 'DESCRIPTION', &           ! (in)
    !         & msg = '(1) Define type "HASH". ' // &
    !         &       '(2) Open the variable. ' // &
    !         &       '(3) set HelpMsg. ' // &
    !         &       '(4) set Options. ' // &
    !         &       '(5) call Debug. ' // &
    !         &       '(6) call Help. ' // &
    !         &       '(7) call Strict.')             ! (in)
    !       call DCArgsHelpMsg( arg = arg, &                         ! (inout)
    !         & category = 'Copyright', &                            ! (in)
    !         & msg = 'Copyright (C) ' // &
    !         &       'GFD Dennou Club, 2008. All rights reserved.') ! (in)
    !       call DCArgsDebug( arg = arg )  ! (inout)
    !       call DCArgsHelp( arg = arg )   ! (inout)
    !       call DCArgsStrict( arg = arg ) ! (inout)
    !       call DCArgsGet( arg = arg, &   ! (inout)
    !         & argv = argv )              ! (out)
    !       write(*,*) '--namelist=', trim( VAL_namelist )
    !       do i = 1, size(argv)
    !         write(*,*) argv(i)
    !       end do
    !       deallocate( argv )
    !       call DCArgsClose( arg = arg )  ! (inout)
    !
    ! ޥɥ饤 '-h', '-H', '--help' ΤŤ줫Υץ
    ! ꤹ뤳Ȥ, HelpMsg Ϳå, ץΰ
    ! ɸϤɽޤ.
    !
    use dc_hash, only: DCHashPut
    use dc_string, only: UChar
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(*), intent(in) :: category
    character(*), intent(in) :: msg
    character(len = *), parameter  :: subname = 'DCArgsHelpMsg'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    call DCHashPut(arg % helpmsg, key=UChar(category), value=msg)
  end subroutine DCArgsHelpMsg
  

  subroutine DCArgsStrict(arg, severe)
    !
    ! ץåԤޤ. 
    !
    ! ޥɥ饤ΥץȤƻꤵ줿Τ,
    ! DCArgsOption ֥롼ꤵƤʤΤ¸ߤ
    ! ˤϷٹ֤ޤ. *severe*  .true. ꤹ
    ! 顼֤ƽλޤ.
    ! Υ֥롼Ƥ, DCArgsOption, DCArgsDebug, 
    ! DCArgsHelp ֥롼ƤǤ.
    !
    ! ¤ ARGS ѿФƤΥ֥롼ŬѤƤ
    ! Ȥ, ޥɥ饤ȤͿץ
    ! ץबǧƤ뤫ɤå뤳ȤǤޤ.
    !
    !
    use dc_types, only: STRING
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    logical, intent(in), optional :: severe
    character(STRING) :: err_mess
    integer :: i
    character(len = *), parameter  :: subname = 'DCArgsStrict'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    do i = 1, size(arg % cmd_opts_list)
      err_mess = trim(arg % cmd_opts_list(i) % name) // ' is invalid option.'
      if (.not. arg % cmd_opts_list(i) % flag_called) then
        if (present_and_true(severe)) then
          call MessageNotify('E', subname, err_mess)
        else
          call MessageNotify('W', subname, err_mess)
        end if
      end if
    end do
  end subroutine DCArgsStrict


  subroutine DCArgsGet(arg, argv)
    !
    ! ޥɥ饤Τ, ץǤϤʤΤ
    ! *argv* ֤ޤ.
    !
    ! *argv* ʸΥݥ󥿤Ǥ.
    ! ȤͿˤɬ֤ͿƤ.
    !
    use dc_types, only: STRING
    use dc_string, only: StoA, StoI, Printf, Concat, JoinChar
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(*), pointer :: argv(:) !(out)
    integer :: i, cmd_argv_max
    character(len = *), parameter  :: subname = 'DCArgsGet'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    cmd_argv_max = size(cmd_argv_list)
    allocate(argv(cmd_argv_max))
    do i = 1, cmd_argv_max
      argv(i) = cmd_argv_list(i)
    end do
  end subroutine DCArgsGet

  function DCArgsNumber(arg) result(result)
    !
    ! ޥɥ饤ȤͿ줿ο֤ޤ.
    !
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    integer :: result
    character(len = *), parameter  :: subname = 'DCArgsGet'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    result = size(cmd_argv_list)
  end function DCArgsNumber

  subroutine DCArgsPutLine(arg)
    !
    ! *arg* ˴ؤɸϤɽޤ.
    !
    use dc_types, only: STDOUT
    use dc_string, only: Printf, JoinChar
    implicit none
    type(ARGS), intent(in) :: arg
    integer :: i
  continue
    if (.not. arg % initialized) then
      call Printf(STDOUT, '#<ARGS:: @initialized=%y>', l=(/arg % initialized/))
      return
    end if
    call Printf(STDOUT, '#<ARGS:: @initialized=%y,', l=(/arg % initialized/))
    call Printf(STDOUT, '  @opt_table(:)=')
    do i = 1, size(arg % opt_table)
      call Printf(STDOUT, '    #<OPT_ENTRY:: ')
      call Printf(STDOUT, '      @options=%c, @help_message=%c, @optvalue_flag=%y', &
        & c1=trim(JoinChar(arg % opt_table(i) % options)), &
        & c2=trim(arg % opt_table(i) % help_message), &
        & l=(/arg % opt_table(i) % optvalue_flag/))
      call Printf(STDOUT, '    >')
    end do
    call Printf(STDOUT, '  ,')
    call Printf(STDOUT, '  @cmd_opts_list(:)=')
    do i = 1, size(arg % cmd_opts_list)
      call Printf(STDOUT, '    #<CMD_OPTS_INTERNAL:: ')
      call Printf(STDOUT, '      @name=%c, @value=%c, @flag_called=%y', &
        & c1=trim(arg % cmd_opts_list(i) % name), &
        & c2=trim(arg % cmd_opts_list(i) % value), &
        & l=(/arg % cmd_opts_list(i) % flag_called/))
      call Printf(STDOUT, '    >')
    end do
    call Printf(STDOUT, '  ,')
    call Printf(STDOUT, '  @cmd_argv_list(:)=%c', &
      & c1=trim(JoinChar(cmd_argv_list)))
    call Printf(STDOUT, '>')

  end subroutine DCArgsPutLine

  subroutine PrintAutoLinefeed(unit, fmt, length, indent)
    !
    ! ʸưԤƽϤޤ. 
    ! Υ⥸塼Ѥ뤿Υ֥롼Ǥ.
    !
    ! *fmt* Ϳ줿ʸϤʸ *length* (ꤵʤ 70)
    ! ˲Ԥ, Ϥޤ. Ϥκ, *indent* ꤵƤ
    ! ʸƬƽϤԤޤ.
    ! ϥǥեȤɸϤȤʤޤ. *unit* ˽ֹ
    ! ꤹ뤳ȤǽѹǤޤ.
    !
    use dc_types, only: STRING, STDOUT
    use dc_string, only: Split
    implicit none
    character(*), intent(in) :: fmt
    integer,      intent(in), optional :: length ! ԤĹ
    character(*), intent(in), optional :: indent ! ʸ
    integer,      intent(in), optional :: unit   ! 
    character(STRING), pointer :: carray_tmp(:) => null()
    character(STRING) :: store_str
    integer, parameter :: default_len = 70
    integer :: i, split_len, indent_len, unit_num
    logical :: new_line_flag
  continue
    if (present(unit)) then
      unit_num = unit
    else
      unit_num = STDOUT
    end if

    if (present(indent)) then
      indent_len = len(indent)
    else
      indent_len = 0
    end if

    if (present(length)) then
      split_len = length - indent_len
    else
      split_len = default_len - indent_len
    end if


    nullify(carray_tmp)
    call Split(fmt, carray_tmp, '')
    store_str = ''
    new_line_flag = .true.
    i = 1
    do
      if (i > size(carray_tmp)) then
        write(unit_num, '(A)') trim(store_str)
        exit
      end if

      if (len(trim(store_str)) + len(trim(carray_tmp(i))) > split_len) then
        if (new_line_flag) then
          write(unit_num, '(A)') trim(carray_tmp(i))
          i = i + 1
        else
          write(unit_num, '(A)') trim(store_str)
          store_str = ''
          new_line_flag = .true.
        end if
        cycle
      end if

      if (new_line_flag .and. present(indent)) then
        store_str = indent // trim(carray_tmp(i))
      else
        store_str = trim(store_str) // ' ' // trim(carray_tmp(i))
      end if
      new_line_flag = .false.
      i = i + 1
    end do

  end subroutine PrintAutoLinefeed

  subroutine SortArgTable
    !
    ! ΰʬΤΥ֥롼Ǥ. 
    !
    ! BuildArgTable ꤵ줿 argind_count, argstr_table 
    ! Ѥ, cmd_argv_list, cmd_opts_list ꤷޤ.
    !
    ! ˰٤ǤƤФƤ, ⤻˽λޤ.
    !
    use dc_types, only: STRING
    implicit none
    character(STRING):: raw_arg, name, value
    integer:: i, cmd_argv_count, cmd_opts_count, cmd_argv_max, cmd_opts_max
  continue
    if (allocated(cmd_opts_list)) return
    cmd_argv_count = 0
    cmd_opts_count = 0
    check_count: do, i = 1, argind_count
      raw_arg = argstr_table(i)
      if (DCOptionFormC(raw_arg, name, value)) then
        cmd_opts_count = cmd_opts_count + 1
      else
        cmd_argv_count = cmd_argv_count + 1
      end if
    end do check_count

    cmd_argv_max = cmd_argv_count
    cmd_opts_max = cmd_opts_count

    allocate(cmd_argv_list(cmd_argv_max))
    allocate(cmd_opts_list(cmd_opts_max))

    cmd_argv_count = 0
    cmd_opts_count = 0
    arg_get : do, i = 1, argind_count
      raw_arg = argstr_table(i)
      if (DCOptionFormC(raw_arg, name, value)) then
        cmd_opts_count = cmd_opts_count + 1
        cmd_opts_list(cmd_opts_count) % name = name
        cmd_opts_list(cmd_opts_count) % value = value
        cmd_opts_list(cmd_opts_count) % flag_called = .false.
      else
        cmd_argv_count = cmd_argv_count + 1
        cmd_argv_list(cmd_argv_count) = raw_arg
      end if
    end do arg_get
  end subroutine SortArgTable

  subroutine BuildArgTable
    !
    ! ޥɥ饤Υ֥롼Ǥ. 
    !
    ! ⥸塼 sysdep  sysdep#SysdepArgCount, sysdep#ArgGet
    ! ƤӽФ, Ƥ argind_count  argstr_table ˳Ǽޤ.
    !
    ! ˰٤ǤƤФƤ, ⤻˽λޤ.
    !
    use sysdep, only: SysdepArgCount, SysdepArgGet
    use dc_types, only: STRING
    implicit none
    integer:: i, narg, nargmax
    character(len = STRING):: value
    character(len = STRING), allocatable:: localtab(:)
  continue
    if (argind_count >= 0) return
    nargmax = SysdepArgCount()
    allocate(localtab(nargmax))
    narg = 0
    do, i = 1, nargmax
      call SysdepArgGet(i, value)
      narg = narg + 1
      localtab(narg) = value
    enddo
    argind_count = narg
    allocate(argstr_table(narg))
    argstr_table(1: narg) = localtab(1: narg)
    deallocate(localtab)
  end subroutine BuildArgTable

  function DCOptionFormC(argument, name, value) result(result)
    !
    ! ȤƤ줿ʸ *argument* ϤȤ,
    ! 줬ץʤΤǤʤΤȽ̤, ⤷
    ! ץȽ̤ˤͤ .true. ֤,
    ! name ˥ץ̾, *value* ˤ֤ͤ.
    ! ץͤղäʤ *value* ˤ϶֤.
    !
    ! ץǤϤʤͤ .false. ֤,
    ! *name*, *value* ˤ϶֤.
    !
    ! ץȽꤵΤϰʲξǤ.
    !
    ! * ʸܤ '-' ξ. ξûץȤʤ, '-'
    !   μΰʸΤߤץȤͭˤʤޤ.
    !
    ! * 1-2ʸܤ '--' ξ. ξĹץȤʤ,
    !   '--' ʹߤʸ󤬥ץȤͭˤʤޤ.
    !
    ! ץͤ, "=" ʸˤʤޤ.
    !
    !=== 
    !
    ! *argument*    :: <b>name,      value, ֤</b>
    ! arg           ::    ,      ,  .false.
    ! -O            ::    -O,        ,  .true.
    ! -debug        ::    -d,        ,  .true.
    ! --debug       ::    --debug,   ,  .true.
    ! -I=/usr       ::    -I,        /usr,  .true.
    ! --include=/usr::    --include, /usr,  .true.
    !
    implicit none
    character(len = *), intent(in):: argument
    character(len = *), intent(out):: name, value
    logical :: result
    integer:: equal
  continue
    equal = index(argument, '=')
    if (argument(1:1) == '-' .and. argument(2:2) /= '-') then
      ! Short Option
      if (equal == 0) then
        name = argument(1:2)
        value = ""
      else
        name = argument(1:2)
        value = argument(equal+1: )
      endif
      result = .true.
    elseif (argument(1:2) == '--') then
      ! Long Option
      if (equal == 0) then
        name = argument
        value = ""
      else
        name = argument(1:equal-1)
        value = argument(equal+1: )
      endif
      result = .true.
!    elseif (equal == 0 .and. &
!      &     verify(argument(1:equal-1), WORDCHARS) == 0) then
!      ! ???
!      name = argument(1:equal-1)
!      value = argument(equal+1: )
!      result = .true.
    else
      ! No Option (normal arguments)
      name = ""
      value = ""
      result = .false.
    endif
  end function DCOptionFormC



end module dc_args
