!= ˴ؤ빽¤ǡ
!= Derived types and parameters of calendar and date 
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dc_calendar_types.f90,v 1.2 2009-10-17 14:08:59 morikawa Exp $
! Tag Name::  $Name: gtool5-20100413 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_calendar_types
  != ˴ؤ빽¤ǡ
  != Derived types and parameters of calendar and date 
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! dc_calendar ˴Ϣ빽¤Τ󶡤ޤ. 
  !
  ! Derived types and parameters for "dc_calendar" are provided. 
  !
  !== Derived types List
  !
  ! DC_CAL       :: 
  ! DC_CAL_DATE  :: 
  ! ------------ ::
  ! DC_CAL       :: Calendar
  ! DC_CAL_DATE  :: Date
  !
  !== Parameters for calender
  !
  ! CAL_USER_DEFINED  :: 1 ǯη, 1 , 1 λֿ, 1 ֤ʬ,
  !                      1 ʬÿǤդǤ. 
  ! CAL_GREGORIAN     :: 쥴ꥪ
  ! CAL_JULIAN        :: ꥦ
  ! CAL_NOLEAP        :: ǯ̵
  ! CAL_360DAY        :: 1 30 
  ! CAL_CYCLIC        :: 
  !                      30.6    ޤǤ
  !                      ξʲڼΤȤ
  ! ------------      ::
  ! CAL_USER_DEFINED  :: A calendar in which number of months of a year, 
  !                      days of a month, hours of a day, minutes of a hour, 
  !                      seconds of a minute are arbitrary. 
  ! CAL_GREGORIAN     :: Gregorian calendar. 
  ! CAL_JULIAN        :: Julian calendar. 
  ! CAL_NOLEAP        :: A calendar without leap year. 
  ! CAL_360DAY        :: A calendar in which number of days of a month is 30. 
  ! CAL_CYCLIC        :: A calendar in which number of days of a year is
  !                      "30.6 x (number of months) - (total days until last month)"
  !                      (truncate fractional part). 
  !
  !== Characters list for unit
  ! 
  ! ñ̤ȤǧʸΥꥹȤǤ. 
  !
  ! List of strings recognized as units of date. 
  ! 
  ! UNIT_SEC          :: äñ
  ! UNIT_MIN          :: ʬñ
  ! UNIT_HOUR         :: ֤ñ
  ! UNIT_DAY          :: ñ
  ! UNIT_MONTH        :: ñ
  ! UNIT_YEAR         :: ǯñ
  ! ------------      ::
  ! UNIT_SEC          :: Units of second
  ! UNIT_MIN          :: Units of minute
  ! UNIT_HOUR         :: Units of hour
  ! UNIT_DAY          :: Units of day
  ! UNIT_MONTH        :: Units of month
  ! UNIT_YEAR         :: Units of year  
  !
  !== Symbols for unit
  !
  ! dc_calendar 󶡤³ǻѤ, 
  ! ñ̤򼨤Ǥ. 
  !
  ! Integers that indicate units of date. 
  ! They are used in procedures provied from "dc_calendar". 
  ! 
  ! UNIT_SYMBOL_SEC    :: äñ
  ! UNIT_SYMBOL_MIN    :: ʬñ
  ! UNIT_SYMBOL_HOUR   :: ֤ñ
  ! UNIT_SYMBOL_DAY    :: ñ
  ! UNIT_SYMBOL_MONTH  :: ñ
  ! UNIT_SYMBOL_YEAR   :: ǯñ
  ! UNIT_SYMBOL_ERR    :: ̵ñ
  ! ------------       ::
  ! UNIT_SYMBOL_SEC    :: Units of second
  ! UNIT_SYMBOL_MIN    :: Units of minute
  ! UNIT_SYMBOL_HOUR   :: Units of hour
  ! UNIT_SYMBOL_DAY    :: Units of day
  ! UNIT_SYMBOL_MONTH  :: Units of month
  ! UNIT_SYMBOL_YEAR   :: Units of year
  ! UNIT_SYMBOL_ERR    :: Invalid unit
  !

  use dc_types, only: DP, TOKEN
  implicit none

  private
  public:: DC_CAL, DC_CAL_DATE
  public:: CAL_USER_DEFINED, CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, &
    &      CAL_GREGORIAN, CAL_360DAY
  public:: UNIT_SEC, UNIT_MIN, UNIT_HOUR, &
    &      UNIT_DAY, UNIT_MONTH, UNIT_YEAR
  public:: UNIT_SYMBOL_SEC, UNIT_SYMBOL_MIN, &
    &      UNIT_SYMBOL_HOUR, UNIT_SYMBOL_DAY, UNIT_SYMBOL_MONTH, &
    &      UNIT_SYMBOL_YEAR, UNIT_SYMBOL_ERR

  integer, parameter:: CAL_USER_DEFINED = 1
                                         ! ѼԤǤդǻꤹ. 
                                         ! User defined calendar. 
                                         !
  integer, parameter:: CAL_CYCLIC = 2    ! 1  30.6  (CYCLIC_MDAYS) 
                                         ! Ȥ. 
                                         !
                                         ! All months are 30.6 day. 
                                         !
  integer, parameter:: CAL_NOLEAP = 3    ! 1 ǯ 365  (ǯ̵) . 
                                         !
                                         ! Gregorian calendar without
                                         ! leap years, i.e., all years
                                         ! are 365 days long.
                                         !
  integer, parameter:: CAL_JULIAN = 4    ! ꥦ. 
                                         ! Julian calendar. 
                                         !
  integer, parameter:: CAL_GREGORIAN = 5 ! 쥴ꥪ. 
                                         ! Gregorian calendar. 
                                         !
  integer, parameter:: CAL_360DAY = 6    ! 1 ǯ 360  (1  30 ) . 
                                         !
                                         ! All years are 360 days 
                                         ! divided into 30 day months.

  type DC_CAL
    !
    ! ɽ빽¤. 
    !
    ! ι¤ΤǤľܤ򻲾ȤѹƤϤʤʤ. 
    ! ι¤Τ򰷤Ǥɬ dc_calendar_generic 󶡤
    ! ³Ѥ뤳. 
    !
    ! A derived type that expresses calendar.  
    ! 
    ! Do not refer and modify elements of this derived type. 
    ! Use procedures provied by "dc_calendar_generic" necessarily 
    ! for handling this derived type. 
    !
    logical:: initialized = .false. 
                              ! ե饰. 
                              ! Initialization flag
    integer:: month_in_year
                              ! 1 ǯη. 
                              ! Months in a year. 
    integer, pointer:: day_in_month(:) => null()
                              ! 1 . 
                              ! Days in months. 
    integer:: hour_in_day
                              ! 1 λֿ. 
                              ! Hours in a day. 
    integer:: min_in_hour
                              ! 1 ֤ʬ. 
                              ! Minutes in a hour. 
    real(DP):: sec_in_min
                              ! 1 ʬÿ. 
                              ! Seconds in a minute. 
    integer:: cal_type
                              ! μ. 
                              ! Kind of calendar. 
  end type DC_CAL

  type DC_CAL_DATE
    !
    ! ɽ빽¤
    !
    ! ι¤ΤǤľܤ򻲾ȤѹƤϤʤʤ. 
    ! ι¤Τ򰷤Ǥɬ dc_calendar_generic 󶡤
    ! ³Ѥ뤳. 
    !
    ! A derived type that expresses date.  
    ! 
    ! Do not refer and modify elements of this derived type. 
    ! Use procedures provied by "dc_calendar_generic" necessarily 
    ! for handling this derived type. 
    !
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
    integer:: year            ! ǯ. Year.  
    integer:: month           ! . Month. 
    integer:: day             ! . Day. 
    integer:: hour            ! . Hour. 
    integer:: min             ! ʬ. Minute. 
    real(DP):: sec            ! . Sec. 
    character(TOKEN):: zone   ! UTC λ. Time-zone. 
  end type DC_CAL_DATE

  ! ñ̤Ȥǧʸ
  ! Strings recognized as units of date and time 
  !
  character(*), parameter, dimension(8) :: UNIT_SEC = (/ &
    & 'seconds', 'second ', 'secs.  ', 'secs   ', &
    & 'sec.   ', 'sec    ', 's.     ', 's      '/) ! äñ̤򼨤ʸ

  character(*), parameter, dimension(4) :: UNIT_MIN = (/ &
    & 'minutes', 'minute ', 'min.   ', 'min    '/) ! ʬñ̤򼨤ʸ
  character(*), parameter, dimension(8) :: UNIT_HOUR = (/ &
    & 'hours', 'hour ', 'hrs. ', 'hrs  ', &
    & 'hr.  ', 'hr   ', 'h.   ', 'h    '/)         ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_DAY = (/ &
    & 'days', 'day ', 'd.  ', 'd   '/)             ! ñ̤򼨤ʸ
  character(*), parameter, dimension(6) :: UNIT_MONTH = (/ &
    & 'months', 'month ', 'mon.  ', &
    & 'mon   ', 'mo.   ', 'mo    '/)               ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_YEAR = (/ &
    & 'years', 'year ', 'yr.  ', 'yr   '/)         ! ǯñ̤򼨤ʸ


  ! ñ̤Υܥ
  ! Synbols of units of date and time
  !
  integer, parameter:: UNIT_SYMBOL_ERR    = -1 ! ̵ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_SEC    = 2 ! äñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_MIN    = 3 ! ʬñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_HOUR   = 4 ! ֤ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_DAY    = 5 ! ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_MONTH  = 6 ! ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_YEAR   = 7 ! ǯñ̤򼨤ܥ

end module dc_calendar_types
