!
!==  (abstruct) netCDF 󥿡ե
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gtdata_netcdf_generic.f90,v 1.1 2009-04-28 11:05:59 morikawa Exp $
! Tag Name::  $Name: gtool5-20090809 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module gtdata_netcdf_generic
  !
  !==  netCDF 󥿡ե
  !

  implicit none
  !
  ! === ܳư ===
  !

  !
  ! an 饤֥Ǥϡ֥եפǤϤʤѿפ򳫤Ĥꤹ롣
  ! ٤ƤΤΤѿȤ°Ǥ롣

  interface Open
    ! 
    ! open(var, url, [writable], [err])  url Ǽ̤
    ! ѿ򳫤 var ˳Ǽ롣ѿȤ netCDF ѿޤ
    ! netCDF Ǥ롣Ʊ̾ netCDF ѿˤξԤ
    ! Ʊ뤵롣writable 򿿤˻ꤹȽ񤭹߲ĤǳȤ롣
    ! ǥեȤ writable=.FALSE. Ǥ롣顼ȯ
    ! err Ȥʤ롣err ͿʤХץߤ롣
    !
    recursive subroutine GDNcVarOpen(var, url, writable, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      logical, intent(in), optional:: writable
      logical, intent(out), optional:: err
    end subroutine GDNcVarOpen
    !
    ! gdnc 饤֥ѿ netCDF ѿȼ礷
    ! Ǥ롣¤Τ¸ߤʤǡgdnc ΩǤ
    ! ѿǤոĤμȸƤФѿĤȤȤˤʤ롣
    ! 輡ѿȸƤФƤΤϡѿʬȤΤߤ
    ! ȤƤľؤ
    !
    ! open(var, src_var, dimord, [count_compact], [err]) 
    ! ˳줿ѿ src_var  ord ܤμˤѿ
    !  var ˳Ǽ롣 ord ϸߤϰϤ
    ! ˤʤäƤ (ѥȲƤˤФ
    ! Ǥ뤬count_compact ˿ꤹ
    ! ٤ƤμΤʤνˤʤ롣
    !
    subroutine GDNcVarOpenByDimOrd(var, src_var, dimord, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(out):: var
      type(GD_NC_VARIABLE), intent(in):: src_var
      integer, intent(in):: dimord
      logical, intent(out), optional:: err
    end subroutine GDNcVarOpenByDimOrd
  end interface

  interface Search_dim
    integer function GDNcSearchDim(var, dimname)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: dimname
    end function GDNcSearchDim
  end interface

  interface Create
    !
    ! °ѿ create
    !
    ! create(var, url, dims, [xtype], [overwrite], [err]) 
    !  url ˼ dims äѿ򳫤
    ! Τ var ˳Ǽ롣 xtype ά real 
    ! ߤʤ롣¸ѿȤԤ뤬
    ! overwrite Ǥ³Ԥ롣
    ! ѿˤ dims ĹϤȡ
    !
    subroutine GDNcVarCreate(var, url, xtype, dims, overwrite, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      character(len = *), intent(in):: xtype
      type(GD_NC_VARIABLE), intent(in):: dims(:)
      logical, intent(in), optional:: overwrite
      logical, intent(out), optional:: err
    end subroutine GDNcVarCreate
    !
    ! ѿ create
    !
    ! create(var, url, xtype, length, [overwrite], [err]) 
    ! Ĺ length μѿ롣
    !
    subroutine GDNcVarCreateD(var, url, xtype, length, overwrite, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      character(len = *), intent(in):: xtype
      integer, intent(in):: length
      logical, intent(in), optional:: overwrite
      logical, intent(out), optional:: err
    end subroutine GDNcVarCreateD
  end interface

  interface
    subroutine GDNcVarDel(varname, hint, stat)
      character(len = *), intent(in):: varname
      character(len = *), intent(in):: hint
      integer, intent(out):: stat
    end subroutine GDNcVarDel
  end interface

  interface Close
    subroutine GDNcVarClose(var, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      logical, intent(out), optional:: err
    end subroutine GDNcVarClose
  end interface

  !
  ! === ѿ˴ؤ䤤碌 ===
  !

  ! mainly for PRINT debugging
  interface toString
    function GDNcVarToString(var) result(result)
      use dc_types, only: STRING
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      character(string):: result
      type(GD_NC_VARIABLE), intent(in):: var
    end function GDNcVarToString
  end interface

  interface Inquire

    subroutine GDNcVarInquire(var, ndims, dimlen, growable, name, url, xtype)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      ! ѿμ
      integer, intent(out), optional:: ndims
      ! ѿǤ硢Ĺ
      integer, intent(out), optional:: dimlen
      ! ѿĹǽĤ
      logical, intent(out), optional:: growable
      ! ʸûͤڤͤ᤬ꤦ
      ! '?' ΤȤѿ̾
      character(*), intent(out), optional:: name
      ! ѿ̾ʤȤե̾ޤࡢʤ٤Ĺ̾
      character(*), intent(out), optional:: url
      ! ѿη̾
      character(*), intent(out), optional:: xtype
    end subroutine GDNcVarInquire

    !  ndims ĤǤʤФʤʤ
    subroutine GDNcVarInquireIA(var, dimlen)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(out):: dimlen(:)
    end subroutine GDNcVarInquireIA

    subroutine GDNcAttrInquire(var, attrname, xtype)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len=*), intent(in):: attrname
      character(len=*), intent(out), optional:: xtype
    end subroutine GDNcAttrInquire

  end interface

  interface InquirePlus

    subroutine GDNcAttrInquirePlus(var, attrname, varid, nf_attrname)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len=*), intent(in):: attrname
      integer, intent(out):: varid
      character(len=*), intent(out):: nf_attrname
    end subroutine GDNcAttrInquirePlus

  end interface

  !
  ! === °ط ===
  !

  ! ٤ƤѿȤ an 饤֥Ω줫顢
  ! °ѿ°Ȥߤʤ롣
  ! °ɤ߼ˤѿ°μ°򸡺롣
  ! °񤭹߻ˤϰ㳰ѿ°Ȥƽ񤭹ࡣ
  ! gtool4 °ȵꤵ줿° Conventions,
  ! gt_version, title, gt_subtitle, comment, source,
  ! institution, production, history ˤĤƤϤޤ
  ! °Ȥƽ񤭹⤦Ȥ롣¸ͤä
  !  Conventions, gt_version  gtool4 ƱΤʤ
  ! ǿ礭ʤ褦ˤ롣history ϵɤ
  ! ɲưԤ¾°̾ˤĤƤϴ¸Ȱۤʤ
  ! °ͤѿ°Ȥƽ񤭹ࡣ

  !
  ! --- ° ---
  !

  ! ѿ var տ路°򤹤٤ƼˤϤޤ
  ! attr_rewind(var) ƤӽФƤ̵¥롼פ
  ! attr_next(var, name, [end]) ƤӽФname ҤȤ
  ! ҤȤĤ°̾Ϳ롣name ʸˤʤäȤ
  ! ٤Ƥ°õȤˤʤ롣ΤȤ end 
  ! ͿƤФ줬ˤʤ뤳ȤǤȽǤ롣

  interface attr_rewind
    subroutine GDNcVarAttrRewind(var)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
    end subroutine GDNcVarAttrRewind
  end interface

  interface attr_next
    subroutine GDNcVarAttrNext(var, name, end)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(out):: name
      logical, intent(out), optional:: end
    end subroutine GDNcVarAttrNext
  end interface

  ! ѿ var ° name  value ˳Ǽ롣
  ! °¸ߤʤ value Ĺ­Ƥ
  ! default 롣°ηϤʤǤ褯Ѵ򤹤롣

  interface get_attr

    subroutine GDNcAttrGetChar(var, name, value, default, stat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      character(len = *), intent(out):: value
      character(len = *), intent(in):: default
      integer, intent(out):: stat
    end subroutine GDNcAttrGetChar

    subroutine GDNcVarGetAttrLogical(var, name, value, default)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(out):: value
      logical, intent(in), optional:: default
    end subroutine GDNcVarGetAttrLogical

    ! ͸ǤϤʤɡΤʤ󥿡եȤȤ....
    ! stat = -1:  °¸ߤʤä
    ! stat = 0 ... size(value):  °ɤ߼ä stat 
    ! stat > size(value):  Ĺ­Τ°ɤ߼ʤä
    !                       stat ɬ

    subroutine GDNcAttrGetReal(var, name, value, stat, default)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real, intent(out):: value(:)
      integer, intent(out):: stat
      real, intent(in), optional:: default
    end subroutine GDNcAttrGetReal

    subroutine GDNcAttrGetDouble(var, name, value, stat, default)
      use dc_types, only: DP
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real(DP), intent(out):: value(:)
      integer, intent(out):: stat
      real(DP), intent(in), optional:: default
    end subroutine GDNcAttrGetDouble

    subroutine GDNcAttrGetInt(var, name, value, stat, default)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      integer, intent(out):: value(:)
      integer, intent(out):: stat
      integer, intent(in), optional:: default
    end subroutine GDNcAttrGetInt

  end interface

  ! ѿ var ° name  value Ǽ롣
  ! °η value ηŬ礹褦ꤵ롣
  !  1 ʸʸȤƳǼ졢 T,
  !  F Ȥʤ롣

  interface Put_Attr

    subroutine GDNcVarPutAttrReal(var, name, value, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real, intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine GDNcVarPutAttrReal

    subroutine GDNcVarPutAttrDouble(var, name, value, err)
      use dc_types, only: DP
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real(DP), intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine GDNcVarPutAttrDouble

    subroutine GDNcVarPutAttrInt(var, name, value, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      integer, intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine GDNcVarPutAttrInt

    subroutine GDNcVarPutAttrLogical(var, name, value, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(in):: value
      logical, intent(out), optional:: err
    end subroutine GDNcVarPutAttrLogical

    subroutine GDNcVarPutAttrChar(var, name, value, xtype, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      character(len = *), intent(in):: value
      character(len = *), intent(in), optional:: xtype
      logical, intent(out), optional:: err
    end subroutine GDNcVarPutAttrChar

  end interface

  interface del_attr
    subroutine GDNcVarDelAttr(var, name, err)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(out), optional:: err
    end subroutine GDNcVarDelAttr
  end interface

  interface copy_attr
    subroutine GDNcVarAttrCopy(to, attrname, from, stat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: to
      character(len = *), intent(in):: attrname
      type(GD_NC_VARIABLE), intent(in):: from
      integer, intent(out):: stat
    end subroutine GDNcVarAttrCopy
  end interface

  !
  ! 
  !

  interface Get

    subroutine GDNcVarGetReal(var, start, count, stride, imap, &
      & siz, value, iostat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real, intent(out):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarGetReal

    subroutine GDNcVarGetDouble(var, start, count, stride, imap, &
      & siz, value, iostat)
      use dc_types, only: DP
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real(DP), intent(out):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarGetDouble

    subroutine GDNcVarGetInt(var, start, count, stride, imap, &
      & siz, value, iostat)
      use dc_types, only: DP
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      integer, intent(out):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarGetInt

  end interface

  interface Put

    subroutine GDNcVarPutReal(var, start, count, stride, imap, &
      & siz, value, iostat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real, intent(in):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarPutReal

    subroutine GDNcVarPutDouble(var, start, count, stride, imap, &
      & siz, value, iostat)
      use dc_types, only: DP
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real(DP), intent(in):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarPutDouble

    subroutine GDNcVarPutInt(var, start, count, stride, imap, &
      & siz, value, iostat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      integer, intent(in):: value(siz)
      integer, intent(out):: iostat
    end subroutine GDNcVarPutInt

  end interface

  !
  ! === ե̾ѿ򤵤 ===
  !

  interface var_search
        
    subroutine GDNcVarSearchInit(iter, urlBase)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE_SEARCH
      type(GD_NC_VARIABLE_SEARCH), intent(out):: iter
      character(len = *), intent(in):: urlBase
    end subroutine GDNcVarSearchInit

    subroutine GDNcVarSearchNext(iter, url, end)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE_SEARCH
      type(GD_NC_VARIABLE_SEARCH), intent(inout):: iter
      character(len = *), intent(out):: url
      logical, intent(out):: end
    end subroutine GDNcVarSearchNext

  end interface

  !
  ! æѡΥ롼 SysDepAbort ƤФ뤿ᡢ
  ! ʬ StoreError 뤳ȤϤʤ
  !

  interface
    subroutine GDNcVarSync(var, stat)
      use gtdata_netcdf_types, only: GD_NC_VARIABLE
      type(GD_NC_VARIABLE), intent(in), optional:: var
      integer, intent(out), optional:: stat
    end subroutine GDNcVarSync
  end interface

  !
  ! an ؤŪѤΤΥ롼
  !
  interface
    subroutine GDNcXTypeName(ixtype, xtype)
      integer, intent(in):: ixtype
      character(*), intent(out):: xtype
    end subroutine GDNcXTypeName
  end interface

end module gtdata_netcdf_generic
