#!/bin/sh
#= Generate shell script "gt5config".
#
# Authors::   Youhei SASAKI, Yasuhiro MORIKAWA, Eizi TOYODA
# Copyright:: Copyright (C) GFD Dennou Club, 2000-2017. All rights reserved.
# License::   See COPYRIGHT[link:../COPYRIGHT]
#
prefix=$PREFIX
fc=$FC
mpifc=$MPIFC
fcflags=$FCFLAGS
ldflags=$LDFLAGS
ldlibs=$LDLIBS
version=$VERSION
out=`basename ${1:-gt5config}`

cat > $out <<END_OF_SCRIPT
#!/bin/sh
#=begin
#== NAME
#((* $out *)) -- output environment variables for using gtool5 library.
#
#get environment variables using gtool5
#
#== SYNTAX
#
# % $out  [OPTIONS]
#
#== DESCRIPTION
#
#((* $out *)) is simple shell script.
#This script output environment variables for using gtool5 library.
#
#== OPTION
#
#:--help
#  display this help message and exit
#:--all
#  display all options
#:--fc
#  output fortran compiler name using gtool5 libarary
#:--mpifc
#  output MPI fortran compiler name using gtool5 libarary
#:--fcflags
#  output fortran FCFLAGS using gtool5 libarary
#:--fflags
#  (for backward compatibility): same as --fcflags
#:--ldflags
#  output fortran LDFLAGS using gtool5 libarary
#:--ldlibs
#  output fortran LDLIBS using gtool5 libarary
#:--prefix
#  output install prefix of gtool5
#:--includedir
#  output include (module file) directory of gtool5 library
#== BUGS
#
#If you find a bug, please report it at SPMODEL Development Group
#<dcstaff_(at)_gfd-dennou.org>
#
#=end

END_OF_SCRIPT

cat >> $out <<END_OF_SCRIPT
prefix="$prefix"
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
includedir=${prefix}/include

fc="$fc"
mpifc="$mpifc"
fcflags="$fcflags"
ldflags="$ldflags"
ldlibs="$ldlibs"
version="$version"

usage() {
	cat <<EOF
Usage: $out [OPTION]

Available values for OPTION include:

  --help        display this help message and exit
  --all         display all options
  --fc          output fortran compiler name using gtool5 libarary
  --mpifc       output MPI fortran compiler name using gtool5 libarary
  --fcflags     output fortran FCFLAGS using gtool5 libarary
  --fflags      backward compatibility, same as --fcflags
  --ldflags     output fortran LDFLAGS using gtool5 library
  --ldlibs      output fortran LDLIBS using gtool5 library
  --prefix      output install prefix of gtool5
  --includedir  output include(module file) directory of gtool5 library
  --version     output version

EOF

	exit \$1

}

all()
{
        echo
        echo "This \$version has been built with the following features: "
        echo
        echo "  --fc         -> \$fc"
        echo "  --mpifc      -> \$mpifc"
        echo "  --fcflags    -> \$fcflags"
        echo "  --fflags     -> \$fcflags"
        echo "  --ldflags    -> \$ldflags"
        echo "  --ldlibs     -> \$ldlibs"
        echo
        echo "  --prefix     -> \$prefix"
        echo "  --includedir -> \$includedir"
        echo "  --version    -> \$version"
        echo
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case "\$1" in
        -*=*) value=`echo "\$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
        *) value= ;;
    esac

    case "\$1" in
    --help)       usage 0              ;;
    --all)        all                  ;;
	--fc)		  echo \$fc            ;;
	--mpifc)	  echo \$mpifc         ;;
	--fcflags)	  echo \$fcflags       ;;
	--fflags)	  echo \$fcflags       ;;
	--ldflags)	  echo \$ldflags       ;;
	--ldlibs)	  echo \$ldlibs        ;;
    --prefix)     echo \$prefix        ;;
    --includedir) echo \$includedir    ;;
    --version)    echo \$version       ;;
	*)
    echo "unknown option: \$1" usage 1 ;;
    esac
    shift
done
exit 0
END_OF_SCRIPT
