************************************************************************
      SUBROUTINE FTRLPR(N,IT,T)
 
      IMPLICIT REAL  (A-H,O-Z)
      DIMENSION IT(5),T(0:N-1,4)

      DATA PI/3.1415926535897932385D0/

      CALL FTZLPR(N,IT,T)

      IT(1)=1-IT(1)

      DO 10 I=0,N-1
      T(I,3)=COS(PI*I/N)
      T(I,4)=SIN(PI*I/N)
   10 CONTINUE
 
      END
************************************************************************
      SUBROUTINE FTRLMN(X,Y,M,N,L,IT,T,ISN)
 
      IMPLICIT REAL  (A-H,O-Z)
      DIMENSION IT(5),T(0:N-1,4)
      DIMENSION X(M,0:N-1,2),Y(M,0:N-1,2)

      IF(ISN.EQ.1) THEN
        CALL FTRLFW(X,Y,M,N,L,IT,T)
      ELSE IF(ISN.EQ.-1) THEN
        CALL FTRLBW(X,Y,M,N,L,IT,T)
      END IF

      END
************************************************************************
      SUBROUTINE FTRLFW(X,Y,M,N,L,IT,T)
 
      IMPLICIT REAL  (A-H,O-Z)
      DIMENSION IT(5),T(0:N-1,4)
      DIMENSION X(M,0:N-1,2),Y(M,0:N-1,2)
 
      F1=0.5D0/N
      F2=F1/2
 
      CALL FTZLMN(X,Y,M,N,IT,T)
 
      DO 10 I=1,M
      X(I,0,1)=(Y(I,0,1)+Y(I,0,2))*F1
   10 CONTINUE
 
      IF(L.EQ.N) THEN
      DO 20 I=1,M
      X(I,0,2)=(Y(I,0,1)-Y(I,0,2))*F1
   20 CONTINUE
 
      ELSE
      DO 30 I=1,M
      X(I,0,2)=0
   30 CONTINUE
      END IF
 
      DO 40 J=1,MIN(L,N-1)
      DO 40 I=1,M
      X(I,J,1)=(        (Y(I,N-J,1)+Y(I,J,1))
     &          +T(J,3)*(Y(I,N-J,2)+Y(I,J,2))
     &          -T(J,4)*(Y(I,N-J,1)-Y(I,J,1)))*F2
      X(I,J,2)=(        (Y(I,N-J,2)-Y(I,J,2))
     &          -T(J,3)*(Y(I,N-J,1)-Y(I,J,1))
     &          -T(J,4)*(Y(I,N-J,2)+Y(I,J,2)))*F2
   40 CONTINUE
 
      END
************************************************************************
      SUBROUTINE FTRLBW(X,Y,M,N,L,IT,T)
 
      IMPLICIT REAL  (A-H,O-Z)
      DIMENSION IT(5),T(0:N-1,4)
      DIMENSION X(M,0:N-1,2),Y(M,0:N-1,2)
 
      IF(L.EQ.N) THEN
      DO 10 I=1,M
      Y(I,0,1)=X(I,0,1)+X(I,0,2)
      Y(I,0,2)=X(I,0,1)-X(I,0,2)
   10 CONTINUE
 
      ELSE
      DO 20 I=1,M
      Y(I,0,1)=X(I,0,1)
      Y(I,0,2)=X(I,0,1)
   20 CONTINUE
      END IF
 
      DO 30 J=1,MIN(N-L-1,L)
      DO 30 I=1,M
      Y(I,J,1)=X(I,J,1)-T(J,3)*X(I,J,2)-T(J,4)*X(I,J,1)
      Y(I,J,2)=X(I,J,2)+T(J,3)*X(I,J,1)-T(J,4)*X(I,J,2)
   30 CONTINUE
 
      DO 40 J=MAX(1,N-L),MIN(N-1,L)
      DO 40 I=1,M
      Y(I,J,1)=         (X(I,N-J,1)+X(I,J,1))
     &          -T(J,3)*(X(I,N-J,2)+X(I,J,2))
     &          +T(J,4)*(X(I,N-J,1)-X(I,J,1))
      Y(I,J,2)=        -(X(I,N-J,2)-X(I,J,2))
     &          -T(J,3)*(X(I,N-J,1)-X(I,J,1))
     &          -T(J,4)*(X(I,N-J,2)+X(I,J,2))
   40 CONTINUE
 
      DO 50 J=L+1,N-L-1
      DO 50 I=1,M
      Y(I,J,1)=0
      Y(I,J,2)=0
   50 CONTINUE
 
      DO 60 J=MAX(L+1,N-L),N-1
      DO 60 I=1,M
      Y(I,J,1)= X(I,N-J,1)-T(J,3)*X(I,N-J,2)+T(J,4)*X(I,N-J,1)
      Y(I,J,2)=-X(I,N-J,2)-T(J,3)*X(I,N-J,1)-T(J,4)*X(I,N-J,2)
   60 CONTINUE
 
      CALL FTZLMN(Y,X,M,N,IT,T)
 
      END
