module gms_size
  use datatype
  use mem_manager
  implicit none
  interface size_x
    module procedure size_x_x
    module procedure size_x_xy
    module procedure size_x_xz
    module procedure size_x_xyz
  end interface

  interface size_y
    module procedure size_y_y
    module procedure size_y_xy
    module procedure size_y_yz
    module procedure size_y_xyz
  end interface

  interface size_z
    module procedure size_z_z
    module procedure size_z_xz
    module procedure size_z_yz
    module procedure size_z_xyz
  end interface

contains
  function size_x_x(input) result(output)
    type(var_x), intent(in) :: input
    integer :: output

    if ( input%grid(1) == 0 ) then 
      output = pub1 - plb1 + 1 
    else  
      output = pub1- plb1  
    end if 
  end function size_x_x

  function size_x_xy(input) result(output)
    type(var_xy), intent(in) :: input
    integer :: output

    if ( input%grid(1) == 0 ) then 
      output = pub1 - plb1 + 1 
    else  
      output = pub1- plb1  
    end if 
  end function size_x_xy

  function size_x_xz(input) result(output)
    type(var_xz), intent(in) :: input
    integer :: output

    if ( input%grid(1) == 0 ) then 
      output = pub1 - plb1 + 1 
    else  
      output = pub1- plb1  
    end if 
  end function size_x_xz

  function size_x_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    integer :: output

    if ( input%grid(1) == 0 ) then 
      output = pub1 - plb1 + 1 
    else  
      output = pub1- plb1  
    end if 
  end function size_x_xyz

  function size_y_y(input) result(output)
    type(var_y), intent(in) :: input
    integer :: output

    if ( input%grid(2) == 0 ) then 
      output = pub2 - plb2 + 1 
    else  
      output = pub2- plb2 
    end if 
  end function size_y_y

  function size_y_xy(input) result(output)
    type(var_xy), intent(in) :: input
    integer :: output

    if ( input%grid(2) == 0 ) then 
      output = pub2 - plb2 + 1 
    else  
      output = pub2- plb2 
    end if 
  end function size_y_xy

  function size_y_yz(input) result(output)
    type(var_yz), intent(in) :: input
    integer :: output

    if ( input%grid(2) == 0 ) then 
      output = pub2 - plb2 + 1 
    else  
      output = pub2- plb2 
    end if 
  end function size_y_yz

  function size_y_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    integer :: output

    if ( input%grid(2) == 0 ) then 
      output = pub2 - plb2 + 1 
    else  
      output = pub2- plb2 
    end if 
  end function size_y_xyz

  function size_z_z(input) result(output)
    type(var_z), intent(in) :: input
    integer :: output

    if ( input%grid(3) == 0 ) then 
      output = pub3 - plb3 + 1
    else  
      output = pub3- plb3  
    end if 
  end function size_z_z

  function size_z_xz(input) result(output)
    type(var_xz), intent(in) :: input
    integer :: output

    if ( input%grid(3) == 0 ) then 
      output = pub3 - plb3 + 1
    else  
      output = pub3- plb3  
    end if 
  end function size_z_xz

  function size_z_yz(input) result(output)
    type(var_yz), intent(in) :: input
    integer :: output

    if ( input%grid(3) == 0 ) then 
      output = pub3 - plb3 + 1
    else  
      output = pub3- plb3  
    end if 
  end function size_z_yz

  function size_z_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    integer :: output

    if ( input%grid(3) == 0 ) then 
      output = pub3 - plb3 + 1
    else  
      output = pub3- plb3  
    end if 
  end function size_z_xyz

end module gms_size
