#! /bin/sh
tmp=$1
tmpdir=$2
cd $2
echo '\documentclass[a5paper]{article}' >$tmp.tex
echo '\begin{document}' >>$tmp.tex
echo '\thispagestyle{empty}' >>$tmp.tex
echo '\newcommand{\D}[3]{ \frac{ d^{#1} #2 }{ d #3^{#1 }} }' >>$tmp.tex
echo '\newcommand{\PD}[3]{ \frac{\partial^{#1} #2}{\partial #3^{#1}} }' >>$tmp.tex
echo '\newcommand{\PDi}[4]{ \left(\frac{\partial^{#1} #2}{\partial #3^{#1}}\right)_{#4}}' >>$tmp.tex
echo '\newcommand{\Vectm}[1]{\mbox{\boldmath $#1$}}' >>$tmp.tex
cat >>$tmp.tex
echo '\end{document}' >>$tmp.tex
platex $tmp.tex > /dev/null 2> /dev/null
dvips -q -E $tmp.dvi -o $tmp.eps
/bin/rm -f $tmp.tex $tmp.log $tmp.dvi $tmp.aux
