!= ʻѥ⥸塼
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: gridset.f90,v 1.14 2014/07/08 01:05:33 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module gridset
  !
  != ʻѥ⥸塼
  !
  !Ϳ줿 NAMELIST ե뤫, ʻ, 
  !ݴɤ뤿ѿȷ⥸塼
  !
  !== Procedures List
  ! gridset_init   :: 롼
  ! gridset_check  :: Ƥå뤿Υ롼
  !

  !⥸塼ɤ߹
  use dc_iounit,     only: FileOpen
  use dc_message,    only: MessageNotify
  use mpi_wrapper,   only: myrank, nprocs
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none
  
  !save °
  private
  
  !ѿ
  integer, public, save :: NX = 10 ! x ʻ
  integer, public, save :: NY = 10 ! y ʻ
  integer, public, save :: NZ = 10 ! z ʻ
  integer, public, save :: NCMAX = 1  ! ǿ
  integer, public, save :: Xmg = 2 ! x ʻ
  integer, public, save :: Ymg = 2 ! y ʻ
  integer, public, save :: Zmg = 3 ! z ʻ
  integer, public, save :: imin    ! x β 
  integer, public, save :: imax    ! x ξ
  integer, public, save :: jmin    ! y β 
  integer, public, save :: jmax    ! y β 
  integer, public, save :: kmin    ! z β 
  integer, public, save :: kmax    ! z β 
  integer, public, save :: xsub = 1
                                   ! Number of MPI processes (X direction)
  integer, public, save :: ysub = 1
                                   ! Number of MPI processes (Y direction)
  logical, public, save :: FlagCalc3D = .true.
  logical, public, save :: FlagCalcMoist = .true.
  integer, save         :: xdim = 1 
  integer, save         :: ydim = 1
  integer, save         :: zdim = 1
  integer, public, save :: nxny = 100 ! x  y ʻ

  ! ֥롼θ
  public gridset_init

contains

  subroutine gridset_init
    !
    != 롼
    !
    ! ե뤫ɤ߹߳ʻ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    integer            :: unit                !եֹ

    !-----------------------------------------------------------------
    ! ե뤫ɤ߹
    !
    NAMELIST /gridset_nml/ xdim, ydim, zdim, NCMAX, Xmg, Ymg, Zmg, xsub, ysub

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=gridset_nml)
    close(unit)

    !-----------------------------------------------------------------    
    ! NX, NY, NZ 
    !
    nx = xdim / xsub 
    imin = 1  - xmg
    imax = nx + xmg
   
    if (ydim == 1) then
      ! 󼡸
      ymg = 0
      ny = 1
      FlagCalc3D = .false. 
    else
      ! 
      ny = ydim / ysub
      FlagCalc3D = .true. 
    end if
    jmin = 1  - ymg
    jmax = ny + ymg

    nz = zdim
    kmin = 1  - zmg
    kmax = nz + zmg    

    nxny = nx * ny

    ! ȥ졼׻Υå
    !
    if ( ncmax == 0 ) then 
!      FlagCalcTracer = .false.
      FlagCalcMoist = .false.
    else
!      FlagCalcTracer = .true.
      FlagCalcMoist = .true.
    end if

    !-----------------------------------------------------------------    
    !"myrank == 0" ˳׻Ρɤ, ɤ߹
    !
    if (myrank == 0) then 
      call MessageNotify( "M", "gridset_init", "xsub = %d",  i=(/xsub/) )
      call MessageNotify( "M", "gridset_init", "ysub = %d",  i=(/ysub/) )
      call MessageNotify( "M", "gridset_init", "xdim = %d",   i=(/xdim/) )
      call MessageNotify( "M", "gridset_init", "ydim = %d",   i=(/ydim/) )
      call MessageNotify( "M", "gridset_init", "zdim = %d",   i=(/zdim/) )
      call MessageNotify( "M", "gridset_init", "[1 node] NX = %d",   i=(/NX/) )
      call MessageNotify( "M", "gridset_init", "[1 node] NY = %d",   i=(/NY/) )
      call MessageNotify( "M", "gridset_init", "[1 node] NZ = %d",   i=(/NZ/) )
      call MessageNotify( "M", "gridset_init", "[1 node] NCMAX = %d",   i=(/NCMAX/) )
      call MessageNotify( "M", "gridset_init", "[1 node] xmg  = %d", i=(/Xmg/) )
      call MessageNotify( "M", "gridset_init", "[1 node] ymg  = %d", i=(/Ymg/) )
      call MessageNotify( "M", "gridset_init", "[1 node] zmg  = %d", i=(/Zmg/) )
      call MessageNotify( "M", "gridset_init", "[1 node] imin = %d", i=(/imin/) )
      call MessageNotify( "M", "gridset_init", "[1 node] imax = %d", i=(/imax/) )
      call MessageNotify( "M", "gridset_init", "[1 node] jmin = %d", i=(/jmin/) )
      call MessageNotify( "M", "gridset_init", "[1 node] jmax = %d", i=(/jmax/) )
      call MessageNotify( "M", "gridset_init", "[1 node] kmin = %d", i=(/kmin/) )
      call MessageNotify( "M", "gridset_init", "[1 node] kmax = %d", i=(/kmax/) )
    end if

    !-----------------------------------------------------------------
    ! ͤΥå
    !    
    call gridset_check

  end subroutine gridset_init
  
!!!-----------------------------------------------------------------
  subroutine gridset_check
    !
    != Ƥå뤿Υ롼
    !
    ! Ƥ̷⤬ʤǧ򤹤. 
    ! ꤬ͭϥ顼åФƽλ.
    ! 
    
    ! nprocs  xsub or ysub ǳڤ뤫å. 
    !
    if ( mod( nprocs, xsub ) /= 0) then
      call MessageNotify( "E", "gridset_init", "mod( nprocs / xsub ) /= 0" )
    end if

    if ( mod( nprocs, ysub ) /= 0) then
      call MessageNotify( "E", "gridset_init", "mod( nprocs / ysub ) /= 0" )
    end if

    if (xsub * ysub /= nprocs) then
      call MessageNotify( "E", "gridset_init", "xsub * ysub /= nprocs" )
    end if

    ! if 3D calculation, xsub > 1 and ysub > 1
    !
!    if ( FlagCalc3D ) then 
!      if ( ysub <= 1 ) then 
!        call MessageNotify( "E", "gridset_init", "ysub has to be > 1" )
!      elseif ( xsub <= 1 ) then 
!        call MessageNotify( "E", "gridset_init", "xsub has to be > 1" )
!       end if
!    end if

    ! X Υޡ礭Υå
    ! 
    if ( xdim < xmg ) then
      call MessageNotify( "E", "gridset_init", "xdim < Xmg" )
    end if

    ! xdim  xsub ǳڤ뤫ǧ
    ! 
    if ( mod(xdim, xsub) /= 0  ) then
      call MessageNotify( "E", "gridset_init", "mod(xdim, xsub) /= 0" )
    end if    

    ! Y Υޡ礭Υå
    ! 
    if ( ydim < ymg ) then
      call MessageNotify( "E", "gridset_init", "ydim < Ymg" )
    end if

    ! ydim  xsub ǳڤ뤫ǧ
    ! 
    if ( mod(ydim, ysub) /= 0  ) then
      call MessageNotify( "E", "gridset_init", "mod(ydim, ysub) /= 0" )
    end if
    
    ! Z Υޡ礭Υå
    ! 
    if ( zdim < zmg ) then
      call MessageNotify( "E", "gridset_init", "zdim < Zmg" )
    end if

  end subroutine gridset_check

end module gridset
