!= CPU ֤η¬ԤΥ⥸塼
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: clockset.f90,v 1.3 2014-01-20 08:12:41 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module clockset
  !
  != CPU ֤η¬ԤΥ⥸塼
  !
  ! CPU ֤η¬ԤΥ֥롼«ͤ⥸塼
  !
  !== Procedures List
  ! ClocksetInit      :: 롼
  ! ClocksetClose     :: CPU ַ¬νλ
  ! ClocksetPredict   :: ץबλޤǤͽ¬ CPU ֡ɽ
  ! ClockSetPreStart  :: CPU ַ¬ (롼)
  ! ClockSetPreStop   :: CPU ַ¬λ (롼)
  ! ClockSetLoopStart :: CPU ַ¬ (֥롼)
  ! ClocksetLoopStop  :: CPU ַ¬λ (֥롼)


  !⥸塼ɤ߹
  !
  use dc_message, only: MessageNotify
  use dc_clock,   only : CLOCK, DCClockCreate, &
    & DCClockClose, DCClockStart, DCClockStop, &
    & DCClockResult, DCClockPredict,           &
    & operator(+)                             ! Access module (⥸塼)
  use mpi_wrapper, only: myrank
  use timeset,     only: TimeA, RestartTime, IntegPeriod

  !ۤηػ
  !
  implicit none

  !°λ
  !
  private
  
  ! Public Interface
  !
  type(CLOCK), save :: clock_init, clock_loop  ! Variables for CPU time counting 
                                               ! CPU ַ¬ѿ
  public ClocksetInit, ClocksetClose, ClocksetPredict
  public ClockSetPreStart, ClockSetPreStop, ClockSetLoopStart, ClocksetLoopStop

contains
   
  subroutine ClocksetInit
    ! 
    != CPU ַ¬ 롼
    !
    implicit none
    
    ! 롼Ѥλ¬
    !
    call DCClockCreate( &           ! Initialize ()
      & clk = clock_init, &         ! (out)
      & name = 'initialization' )   ! (in)

    ! ȯŸ롼Ѥλ¬
    !
    call DCClockCreate( &           ! Initialize ()
      & clk = clock_loop, &         ! (out)
      & name = 'time-integration' ) ! (in)

  end subroutine ClocksetInit


  subroutine ClocksetPreStart
    !
    != CPU ַ¬ (롼)
    !
    implicit none
    
    call DCClockStart(clk = clock_init) ! (inout)   ! Start CPU time counting 
    
  end subroutine ClocksetPreStart
  

  subroutine ClocksetPreStop
    !
    != CPU ַ¬λ (롼)
    !
    implicit none
    
    call DCClockStop(clk = clock_init) ! (inout)    ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)    
  end subroutine ClocksetPreStop


  subroutine ClocksetLoopStart
    !
    != CPU ַ¬ (֥롼)
    !
    implicit none

    call DCClockStart(clk = clock_loop) ! (inout)   ! Start CPU time counting 

  end subroutine ClocksetLoopStart


  subroutine ClocksetLoopStop
    !
    != CPU ַ¬λ (֥롼)
    !
    implicit none

    call DCClockStop(clk = clock_loop) ! (inout)    ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)    

  end subroutine ClocksetLoopStop


  subroutine ClocksetPredict
    !
    != ץबλޤǤͽ¬ CPU , ɽ
    !
    ! ö¬ߤƤ, ͽͤɽ, ¬Ƴ. 
    !
    implicit none

    real(4) :: progress 

    ! ׻οʹԤγ׻
    progress = real((TimeA - RestartTime) / IntegPeriod, 4)

    ! CPU time measurement stops, temporarily.
    call ClocksetLoopStop

    if (myrank == 0) then 
      call MessageNotify( "M", "ClockSet", "Time = %f", d=(/TimeA/) )

      call DCClockPredict( &                       ! Ĥ֤ͽ¬
        &   clk = clock_init + clock_loop,       & ! (in)
        &   progress = progress                  & ! (in) 
        &  )
    end if

    ! CPU time measurement starts again.
    call ClocksetLoopStart

  end subroutine ClocksetPredict


  subroutine ClocksetClose
    !
    != CPU ַ¬νλ
    !
    ! ¬λ, CPU ֤ɽ.
    !
    implicit none

    if (myrank == 0) then     
      call DCClockResult( &                    !  CPU ֤ɽ
        & clks = (/clock_init, clock_loop/), & ! (in)
        & total_auto = .true. )                ! (in)
    end if
    call DCClockClose( clk = clock_init )      ! (inout) ! Finalize ()
    call DCClockClose( clk = clock_loop )      ! (inout) ! Finalize ()
    
  end subroutine ClocksetClose
  
end module clockset
