!= ñ: Ȥ٤
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: radiation_simple.f90,v 1.10 2014-03-04 04:49:41 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module Radiation_Simple
  !
  ! ñ: Ȥ٤

  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable

  use mpi_wrapper,only: myrank
  use gridSet,  only: imin,     & !x β
    &                 imax,     & !x ξ
    &                 jmin,     & !y β
    &                 jmax,     & !y ξ
    &                 kmin,     & !z β
    &                 kmax        !z ξ
  use axesset,  only: z_Z         !Z ɸ(顼ʻ)
  use constants,only: DayTime     ! 1 Ĺ [s]
  use basicset, only: xyz_ExnerBZ !ʡؿδܾ
  use DExnerDt, only: xyz_DExnerDt_xyz
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none

  !private °
  private

  !ѿ
  real(DP), save, allocatable, public :: xyz_PTempRadVary(:,:,:)   
                                           !ͲǮ
  real(DP), save, allocatable, public :: xyz_PTempRadConst(:,:,:)  
                                           !ͲǮ
  real(DP), save, allocatable, public :: xyz_ExnerRadVary(:,:,:)   
                                           !ǮǮ
  real(DP), save, allocatable, public :: xyz_ExnerRadConst(:,:,:) 
                                           !ǮǮ 

  logical, save :: FlagDExnerDtRad = .true.

  public Radiation_Simple_init

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_Simple_init
    !
    !NAMELIST Ψ, ΰ.
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP) :: HeightUp   = 0.0d0  !ͶͿľΰξ
    real(DP) :: HeightDown = 0.0d0  !ͶͿľΰβ
    real(DP) :: RadHeatRate = 0.0d0 !ͲǮΨ [K/day]
    integer  :: k                   !롼ѿ
    integer  :: unit

    character(*), parameter:: module_name = 'Radiation_Simple_Init'


    ! NAMELIST 
    NAMELIST /radiation_simple_nml/ &
      & RadHeatRate, HeightUp, HeightDown, &
      & FlagDExnerDtRad

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=radiation_simple_nml)
    close(unit)

    allocate( xyz_PTempRadVary(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_PTempRadConst(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_ExnerRadVary(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_ExnerRadConst(imin:imax, jmin:jmax, kmin:kmax) )

    
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    !
    do k = kmin, kmax
      if ( z_Z(k) <= HeightDown  ) then
        xyz_PTempRadConst(:,:,k) = 0.0d0 
      elseif( z_Z(k) >= HeightUp ) then
        xyz_PTempRadConst(:,:,k) = 0.0d0 
      else
        xyz_PTempRadConst(:,:,k) = RadHeatRate / DayTime / xyz_ExnerBZ(:,:,k)
      end if
    end do
    
    if ( FlagDExnerDtRad ) then
      xyz_ExnerRadConst = xyz_DExnerDt_xyz(xyz_PTempRadConst)
    else
      xyz_ExnerRadConst = 0.0d0
    end if

    
    ! ̤Ͷ.
    ! ɽ̤ HeightDown ޤǤ RadHeatRate . 
    ! HeightUp ϲǮΨˤʤ褦˲ǮΨ򸺾.
    ! Nakajima and Matsuno(1988),(1944)򻲹ͤˤ
    !
    do k = kmin, kmax
      if ( z_Z(k) <= HeightDown ) then
        xyz_PTempRadVary(:,:,k) = RadHeatRate / DayTime / xyz_ExnerBZ(:,:,k)
        
      elseif ( z_Z(k) > HeightDown .AND. z_Z(k) <= HeightUP) then
        xyz_PTempRadVary(:,:,k) =  &
          & RadHeatRate / DayTime / xyz_ExnerBZ(:,:,k) &
          & * (HeightUP - z_Z(k)) / (HeightUP - HeightDown) 
        
      else if (z_Z(k) > HeightUP) then
        xyz_PTempRadVary(:,:,k) = 0.0d0
      end if
    end do

    if ( FlagDExnerDtRad ) then
      xyz_ExnerRadVary = xyz_DExnerDt_xyz(xyz_PTempRadVary) 
    else
      xyz_ExnerRadVary = 0.0d0
    end if

    ! Output
    !
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & module_name, "RadHeatRate = %f", d=(/RadHeatRate/))
      call MessageNotify( "M", &
        & module_name, "HeightUp = %f", d=(/HeightUP/))
      call MessageNotify( "M", &
        & module_name, "HeightDown= %f", d=(/HeightDown/))
      call MessageNotify( "M", &
        & module_name, "FlagDExnerDtRad= %b", l=(/ FlagDExnerDtRad /))
    end if

    ! ҥȥǡ
    ! 
    call HistoryAutoAddVariable(  &
      & varname='PTempRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of Exner function', &
      & units='K.s-1',    &
      & xtype='float')

  end subroutine Radiation_Simple_init

end module Radiation_Simple
