!= Module Radiation
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: radiation_bs1998.f90,v 1.3 2014-03-04 05:55:05 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module Radiation_bs1998
  !
  ! Baker et al (1998) ϤͶͿ뤿Υ⥸塼
  !

  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable

  use mpi_wrapper,only: myrank
  use gridSet,  only: imin,     & !x β
    &                 imax,     & !x ξ
    &                 jmin,     & !y β
    &                 jmax,     & !y ξ
    &                 kmin,     & !z β
    &                 kmax        !z ξ
  use axesset,  only: z_Z, dz     !Z ɸ(顼ʻ)
  use constants,only: CpDry       ! 1 Ĺ [s]
  use basicset, only: xyz_ExnerBZ, & !ʡؿδܾ
    &                 xyz_DensBZ     !ܾ̩
  use DExnerDt, only: xyz_DExnerDt_xyz
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none

  !private °
  private

  !ѿ
  real(DP), save, allocatable, public :: xyz_PTempRadBS1998(:,:,:)  !ͲǮ¸ߤΰ
  real(DP), save, allocatable, public :: xyz_ExnerRadBS1998(:,:,:)  !ͲǮ¸ߤΰ

  character(*), parameter:: module_name = 'radiation_bs1998'
                              ! ⥸塼̾.
                              ! Module name
  public Radiation_bs1998_init

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_bs1998_init
    !
    ! 롼: BS1998 ѤƤǮѤ
    !

    !ۤηػ
    implicit none

    !ѿ
    integer  :: k             !롼ѿ

    allocate( xyz_PTempRadBS1998(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_ExnerRadBS1998(imin:imax, jmin:jmax, kmin:kmax) )
    
    ! ̤Ͷ.
    ! BS1998 ѤƤǮΥץեѤ
    !
    do k = kmin, kmax
      xyz_PTempRadBS1998(:,:,k) = cal_Qsub( z_Z(k) ) / CpDry / xyz_DensBZ(:,:,k) / xyz_ExnerBZ(:,:,k)
    end do
    xyz_ExnerRadBS1998 = xyz_DExnerDt_xyz( xyz_PTempRadBS1998 ) 

    ! Output
    !
    call HistoryAutoAddVariable(  &
      & varname='PTempRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double')

    call HistoryAutoAddVariable(  &
      & varname='ExnerRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of Exner function', &
      & units='K.s-1',    &
      & xtype='double')

  end subroutine Radiation_bs1998_init


  function cal_Qsub( z0 )
    ! 
    ! BS1989 ѤƤǮμ
    ! Ʊ롼 surfaceflux_bs1998.f90 ˤޤޤƤΤդ뤳.

    
    implicit none

    real(DP), intent(in) :: z0
    real(DP)             :: cal_Qsub
    real(DP), parameter  :: z_Upper = 6.70d4      ! ĺ
    real(DP), parameter  :: z_Lower = 2.70d4      ! ĺ
    real(DP), parameter  :: c_Upper = 2.70d-2     !  1 
    real(DP), parameter  :: c_Lower = 3.60d-3     !  2 
    real(DP), parameter  :: s_Upper = 7.50d3      !  1 ɸк
    real(DP), parameter  :: s_Lower = 1.30d4      !  2 ɸк

    cal_Qsub =                                                                      &
      & (                                                                           &
      &     c_Lower * exp( - ( z0 - z_Lower )**2.0d0 / ( 2.0d0 * s_Lower **2.0d0) ) &
      &   + c_Upper * exp( - ( z0 - z_Upper )**2.0d0 / ( 2.0d0 * s_Upper **2.0d0) ) &
      &  ) 
    
    
  end function cal_Qsub


end module Radiation_bs1998
