#!/usr/bin/perl

use Jcode;
$correct_default = 'euc';  # 'euc' or 'sjis' or 'jis' or 'utf8'
$jcodecheck_size = 1024;

if ($#ARGV < 2){
    die "Usage: kanjichecker.pl [euc|sjis|jis|utf8] dir path_to_file\n";
}

$current = $ARGV[0] || $current_default;
$dir     = $ARGV[1];
$file    = $ARGV[2];

# if file was removed already, check isn't need.
unless (-f $file) {
    exit 0;
}

open(FILE, "<$file")
    || die "$file: cannot open for reading.";

$count = 0;
until (eof(FILE)) {
    $count++;
    undef $code;
    read(FILE, $char, $jcodecheck_size);
    #print "line=$count\n";
    ($code, $nmatch) = getcode(\$char);
#    print "$code" ; 
#    print "$nmatch" ;
#    print "$char" ;
    if ($count == 1) {
	exit 0 if ($char =~ /^\x89PNG\r/); # for PNG format image files.
	exit 0 if ($char =~ /^GIF8[79]a/); # for GIF format image files.
	exit 0 if ($char =~ /^\xFF\xD8/); # for JPEG format image files.
	exit 0 if ($char =~ /^\x42\x4D/); # for BMP format image files.
	exit 0 if ($char =~ /^CDF(\x01|\x02)/); # for NetCDF format data files.
	exit 0 if ($char =~ /^#-\*-\ mode:\ yaml/); # for yml format data files.
    }
    if ($code eq 'binary') {
        exit 0;
    } elsif ($code eq 'ascii') {
        next;
    } elsif ($code eq $current) {
        next;
    } elsif ($code eq '') {
        next;
        #print "Jcode::getcode can not be get correct code.\n" ;
    } else {
        die "$file include $code, current code is $current.\n";
    }
}

close(FILE);

exit 0;
