!= Module StoreSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storeset.f90,v 1.8 2006/11/22 15:38:22 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module storeset
  !
  !ѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  SpcNum,      & ! number of species
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StoreSet_Init, StoreMeanX, StoreClean
  public z_Adv,  z_Turb, z_Disp, z_Diff, z_Rad, &
    &    z_Cond, z_Flux, z_Damp
  public z_Stab, z_StabTemp, z_StabMolWt, za_MixRt
  public StoreAdv,  StoreTurb, StoreDisp, StoreDiff, StoreRad, &
    &    StoreCond, StoreFlux, StoreDamp
  public StoreStab, StoreMixRt

  !ѿ
  real(8), allocatable :: z_Adv(:)
  real(8), allocatable :: z_Turb(:)
  real(8), allocatable :: z_Disp(:)
  real(8), allocatable :: z_Diff(:)
  real(8), allocatable :: z_Rad(:)
  real(8), allocatable :: z_Damp(:)
  real(8), allocatable :: z_Cond(:)
  real(8), allocatable :: z_Flux(:)
  real(8), allocatable :: xz_Adv(:,:)
  real(8), allocatable :: xz_Turb(:,:)
  real(8), allocatable :: xz_Disp(:,:)
  real(8), allocatable :: xz_Diff(:,:)
  real(8), allocatable :: xz_Rad(:,:)
  real(8), allocatable :: xz_Damp(:,:)
  real(8), allocatable :: xz_Cond(:,:)
  real(8), allocatable :: xz_Flux(:,:)
  real(8), allocatable :: z_Stab(:)
  real(8), allocatable :: z_StabTemp(:)
  real(8), allocatable :: z_StabMolWt(:)
  real(8), allocatable :: xz_Stab1(:,:)
  real(8), allocatable :: xz_Stab2(:,:)
  real(8), allocatable :: xz_Stab3(:,:)
  real(8), allocatable :: za_MixRt(:,:)
  real(8), allocatable :: xza_MixRt1(:,:,:)
  
  !save °
  save xz_Adv,  xz_Turb, xz_Disp, xz_Diff, xz_Rad, &
    &  xz_Cond, xz_Flux, xz_Damp
  save xz_Stab1, xz_Stab2, xz_Stab3, xza_MixRt1

contains

  subroutine StoreSet_Init( )
    !롼

    allocate(     &
      & z_Adv(DimZMin:DimZMax),  & 
      & z_Turb(DimZMin:DimZMax), &
      & z_Disp(DimZMin:DimZMax), &
      & z_Diff(DimZMin:DimZMax), &
      & z_Rad(DimZMin:DimZMax),  &
      & z_Damp(DimZMin:DimZMax), &
      & z_Cond(DimZMin:DimZMax), &
      & z_Flux(DimZMin:DimZMax), &
      & xz_Adv(DimXMin:DimXMax, DimZMin:DimZMax),  & 
      & xz_Turb(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Disp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Diff(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Rad(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_Damp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Flux(DimXMin:DimXMax, DimZMin:DimZMax), &
      !
      & z_Stab(DimZMin:DimZMax),      &
      & z_StabTemp(DimZMin:DimZMax),  &
      & z_StabMolWt(DimZMin:DimZMax), &
      & xz_Stab1(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Stab2(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Stab3(DimXMin:DimXMax, DimZMin:DimZMax), &
      !
      & za_MixRt(DimZMin:DimZMax, SpcNum), &
      & xza_MixRt1(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum) &
      &  )
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0
    z_Flux = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
    xz_Flux = 0.0d0
   
    z_Stab      = 0.0d0
    z_StabTemp  = 0.0d0
    z_StabMolWt = 0.0d0

    xz_Stab1 = 0.0d0
    xz_Stab2 = 0.0d0
    xz_Stab3 = 0.0d0

    za_MixRt  = 0.0d0
    xza_MixRt1 = 0.0d0

!    CalNum  = 1.0d-40    !ػ. 
  end subroutine StoreSet_Init


  subroutine StoreClean( )
    !ݴɤͤΥꥢ
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0
    z_Flux = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
    xz_Flux = 0.0d0
   
    z_Stab      = 0.0d0
    z_StabTemp  = 0.0d0
    z_StabMolWt = 0.0d0

    xz_Stab1 = 0.0d0
    xz_Stab2 = 0.0d0
    xz_Stab3 = 0.0d0

    za_MixRt  = 0.0d0
    xza_MixRt1 = 0.0d0

!    CalNum  = 1.0d-40    !ػ. 
  end subroutine StoreClean


  subroutine StoreMeanX( )
    !ݴɤͤοʿʿ [K/s]
    real(8) :: CalNum

    CalNum = TimeDisp / DelTimeLong 
    
    z_Adv  = a_MeanX_aa( xz_Adv )   / CalNum
    z_Turb = a_MeanX_aa( xz_Turb )  / CalNum
    z_Diff = a_MeanX_aa( xz_Diff )  / CalNum
    z_Disp = a_MeanX_aa( xz_Disp )  / CalNum
    z_Rad  = a_MeanX_aa( xz_Rad  )  / CalNum
    z_Damp = a_MeanX_aa( xz_Damp )  / CalNum
    z_Cond = a_MeanX_aa( xz_Cond )  / CalNum
    z_Flux = a_MeanX_aa( xz_Flux )  / CalNum

    z_Stab      = a_MeanX_aa( xz_Stab1 ) / CalNum
    z_StabTemp  = a_MeanX_aa( xz_Stab2 ) / CalNum
    z_StabMolWt = a_MeanX_aa( xz_Stab3 ) / CalNum

    za_MixRt    = aa_MeanX_aaa( xza_MixRt1 ) / CalNum

    !褹ݤпץåȤ򤹤Τ, ͤ˥äߤʤ
    where ( za_MixRt < 1.0d-20 )
      za_MixRt = 1.0d-20
    end where

  end subroutine StoreMeanX


  subroutine StoreAdv( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Adv + Work
    xz_Adv = Work2

  end subroutine StoreAdv


  subroutine StoreTurb( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Turb + Work
    xz_Turb = Work2

  end subroutine StoreTurb


  subroutine StoreDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Diff + Work
    xz_Diff = Work2

  end subroutine StoreDiff


  subroutine StoreDisp( Work )
    !Ǯݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Disp + Work
    xz_Disp = Work2

  end subroutine StoreDisp


  subroutine StoreRad( Work )
    !ѹݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Rad + Work
    xz_Rad = Work2

  end subroutine StoreRad


  subroutine StoreDamp( Work )
    !ԥ󥰹ݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Damp + Work
    xz_Damp = Work2

  end subroutine StoreDamp


  subroutine StoreCond( Work )
    !ǮȯǮݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Cond + Work
    xz_Cond = Work2

  end subroutine StoreCond


  subroutine StoreFlux( Work )
    !ɽ̥եåݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Flux + Work
    xz_Flux = Work2

  end subroutine StoreFlux


  subroutine StoreStab( Work1, Work2, Work3 )
    !٤ݴ

    implicit none
    
    real(8), intent(in)  :: Work1(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: Work3(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkC(DimXMin:DimXMax, DimZMin:DimZMax)

    WorkA    = Work1 + xz_Stab1 
    xz_Stab1 = WorkA

    WorkB    =  Work2 + xz_Stab2
    xz_Stab2 = WorkB

    WorkC    = Work3 + xz_Stab3
    xz_Stab3 = WorkC

  end subroutine StoreStab


  subroutine StoreMixRt( Work1 )
    !Store Mixing ratio of species

    implicit none
    
    real(8), intent(in)  :: Work1(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: WorkA(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    WorkA      = Work1 + xza_MixRt1
    xza_MixRt1 = WorkA

  end subroutine StoreMixRt


  function a_MeanX_aa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: a_MeanX_aa(DimZMin:DimZMax)
                                     !ʿʿ

    a_MeanX_aa = sum( var(RegXMin+1:RegXMax, :), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 

  end function a_MeanX_aa
  

  function aa_MeanX_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: aa_MeanX_aaa(DimZMin:DimZMax, SpcNum)
                                     !ʿʿ

    aa_MeanX_aaa = sum( var(RegXMin+1:RegXMax,:,:), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 
    
  end function aa_MeanX_aaa
  

  
end module storeset
