  subroutine BasicSet_file_init(basicfile)
    !
    !ܾͤ netCDF ե뤫. 
    !netCDF ͤ뤿 gt4f90io Ѥ. 
    !
    
    !⥸塼ɤ߹
    use gt4_history
    use gridset,    only: DimXMin,  &!  X β
      &                   DimXMax,  &!  X ξ
      &                   DimZMin,  &!  Z β
      &                   DimZMax,  &!  Z ξ
      &                   SpcNum     ! ؼο
    
    !ѿ
    character(*), intent(in) :: basicfile
   
    !ѿ
    character(20)  :: name            !ѿ̾
    
    !ѿ. save °ɬפʤ
    real(8), allocatable  :: xz_DensBasicZ(:,:)    !̩
    real(8), allocatable  :: xz_PressBasicZ(:,:)   !̵
    real(8), allocatable  :: xz_ExnerBasicZ(:,:)   !̵
    real(8), allocatable  :: xz_TempBasicZ(:,:)    !
    real(8), allocatable  :: xz_PotTempBasicZ(:,:) !
    real(8), allocatable  :: xz_VelSoundBasicZ(:,:)!®
    real(8), allocatable  :: xza_MixRtBasicZ(:,:,:)!Žʬ
    real(8), allocatable  :: xz_EffMolWtBasicZ(:,:)!ʬ̸

    !γ
    allocate(  &
      & xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),    &
      & xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),    &
      & xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),     &
      & xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),     &
      & xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), & 
      & xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax) )
    
    !netCDF File ܾξ. 
    name = "PressBasicZ"
    call HistoryGet( basicfile, name, xz_PressBasicZ )
    
    name = "ExnerBasicZ"
    call HistoryGet( basicfile, name, xz_ExnerBasicZ )

    name = "TempBasicZ"
    call HistoryGet( basicfile, name, xz_TempBasicZ )

    name = "PotTempBasicZ"
    call HistoryGet( basicfile, name, xz_PotTempBasicZ )

    name = "DensBasicZ"
    call HistoryGet( basicfile, name, xz_DensBasicZ )

    name = "VelSoundBasicZ"
    call HistoryGet( basicfile, name, xz_VelSoundBasicZ ) 

    name = "MixRtBasicZ"
    call HistoryGet( basicfile, name, xza_MixRtBasicZ ) 

    name = "EffMolWtBasicZ"
    call HistoryGet( basicfile, name, xz_EffMolWtBasicZ ) 


    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSet_Init(                                       &
      & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
      & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
      & xza_MixRtBasicZ, xz_EffMolWtBasicZ )


    !----------------------------------------------------------
    ! γ
    !----------------------------------------------------------
    deallocate(                                               &
      & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
      & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
      & xza_MixRtBasicZ, xz_EffMolWtBasicZ )

  end subroutine BasicEnvFile_Init

