# Title: Ruby script drawing contour map for deepconv/arare5 output data 
#
# History: 2011/09/27 (Masatsugu Odaka)
#
require "numru/ggraph"
include NumRu

file0 = 'odaka1998_restart.nc'
file1 = 'odaka1998_10_VelX.nc'
varname0 = 'DensBZ'
varname1 = 'VelX'

ltime = 864000.0

dens = GPhys::IO.open(file0, varname0)
velx = GPhys::IO.open(file1, varname1)
time  = GPhys::IO.open(file1, 't').val
z    = GPhys::IO.open(file1, 'z').val
dz   = GPhys::IO.open(file1, 'z')

dz = 200.0

var = - velx*dz*dens[5..204,0,5..54]

for l in 0...time.length
  for k in 1...z.length
    var[0..-1,0..-1,k,l] =  var[0..-1,0..-1,k-1,l] + var[0..-1,0..-1,k,l] 
  end
end 


# <Open DCL>
DCL.swlset( 'ldump', true )
DCL.gropn(4)
GGraph.set_fig('viewport'=>[0.1,0.8,0.4,0.6])

#for i in 0...time.length do
# <Drawing data by GGraph>
#  GGraph.tone( var.cut(true,100,true,time[i]) )
#  GGraph.contour( var.cut(true,100,true,time[i]), false )

  GGraph.tone( var.cut(true,100,true,ltime), true,\
               'title'=>'Mass stream function')
  GGraph.contour( var.cut(true,100,true,ltime), false )
  GGraph.color_bar( 'tickintv'=>5, 'landscape'=>true )
#end

# <Close DCL>
DCL.grcls
