!= Module Damping
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: damping.f90,v 1.9 2012-01-12 11:53:11 sugiyama Exp $
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ΨȤη׻ԤΥѥå⥸塼
!  * ݥؤ(նȤȿͤޤۼ뤿)
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * δؿ, ܾ줬ѿ(®, ʡؿξ)
!    ŬѤ뤳ȤꤷƤ. 
!  * ƳʻФؿɬפ
!
!== Future Plans
!
!

module Damping
  !
  !ΨȤη׻ԤΥѥå⥸塼
  !  * ݥؤ(նȤȿͤޤۼ뤿)
  ! 

  !⥸塼ɤ߹
  use dc_types, only : DP

  !ۤηػ
  implicit none

  !private °
  private 
  
  !ؿˤ public °
  public Damping_Init
  public SpongeLayer_forcing

  !ѿ
  real(DP), save :: EFTime     = 100.0d0 !ݥؤ e-folding time
  real(DP), save :: DampDepthH = 0.0d0   !ݥؤθ(ʿ)
  real(DP), save :: DampDepthV = 0.0d0   !ݥؤθ(ľ)
  real(DP), allocatable, save :: xyz_Gamma(:,:,:) !xyz ʻҸ그(ʿ)
  real(DP), allocatable, save :: pyz_Gamma(:,:,:) !pyz ʻҸ그(ľ)
  real(DP), allocatable, save :: xqz_Gamma(:,:,:) !xqz ʻҸ그(ľ)
  real(DP), allocatable, save :: xyr_Gamma(:,:,:) !xyr ʻҸ그(ľ)

contains 
  
!!!------------------------------------------------------------------------!!!
  subroutine Damping_Init
    !
    ! ȸȥݥؤθ그ν
    ! 
    use dc_iounit,  only: FileOpen
    use dc_message, only: MessageNotify
    use gtool_historyauto, only: HistoryAutoAddVariable
    use mpi_wrapper, only: myrank
    use gridset, only: imin,       &! x β
      &                imax,       &! x ξ
      &                jmin,       &! y β
      &                jmax,       &! y ξ
      &                kmin,       &! z β
      &                kmax,       &! z ξ
      &                nx,         &! x ʪΰξ
      &                ny,         &! y ʪΰξ
      &                nz           ! z ʪΰξ
    use axesset, only: x_X,        &!X ɸ(顼ʻ)
      &                y_Y,        &!Y ɸ(顼ʻ)
      &                z_Z,        &!Z ɸ(顼ʻ)
      &                p_X,        &!X ɸ(եåʻ)
      &                q_Y,        &!Y ɸ(եåʻ)
      &                r_Z,        &!Z ɸ(եåʻ)
      &                x_dx, y_dy, z_dz, &! ʻҴֳ
      &                XMax,          &!X ɸκ
      &                YMax,          &!Y ɸκ
      &                ZMax            !Z ɸκ 
    use namelist_util, only: namelist_filename
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP)                  :: Time     !
    real(DP)                  :: DepthH   !ݥؤθ(ʿ)
    real(DP)                  :: DepthV   !ݥؤθ(ľ)
    real(DP), parameter       :: Pi =3.1415926535897932385d0   !߼Ψ
    integer                   :: unit ! ֹ
    integer                   :: i, j, k

    !NAMELIST 
    NAMELIST /damping_nml/ Time, DepthH, DepthV

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=damping_nml)
    close(unit)

    !
    allocate( &
      & xyz_Gamma(imin:imax,jmin:jmax,kmin:kmax), &
      & pyz_Gamma(imin:imax,jmin:jmax,kmin:kmax), &
      & xqz_Gamma(imin:imax,jmin:jmax,kmin:kmax), &
      & xyr_Gamma(imin:imax,jmin:jmax,kmin:kmax)    )
    xyz_Gamma = 0.0d0
    pyz_Gamma = 0.0d0
    xqz_Gamma = 0.0d0
    xyr_Gamma = 0.0d0

    write(*,*) "++++++++ damping.f90 +++++++++", Time, DepthH, DepthV

    !ͤ
    EFTime     = Time
    DampDepthH = DepthH
    DampDepthV = DepthV
    
    !-----------------------------------------------------------------    
    ! ݥؤθΨ
    !

    !ʿ¦¦
    !
    if ( DampDepthH < x_dx(1) ) then 
      if (myrank == 0) &
        & call MessageNotify( "W", "Damping_init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(1)/))

    else if ( DampDepthH < x_dx(nx) ) then 
      if (myrank == 0) &
        & call MessageNotify( "W", "Damping_init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(nx)/))

    else
      do i = imin, imax
        !顼ʻ¦
        if ( x_X(i) < DampDepthH) then 
          xyz_Gamma(i,:,:) = xyz_Gamma(i,:,:) &
            & + ((1.0d0 - x_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( p_X(i) < DampDepthH) then 
          pyz_Gamma(i,:,:) = pyz_Gamma(i,:,:) &
            & + ((1.0d0 - p_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !顼ʻ¦    
        if ( x_X(i) > ( XMax - DampDepthH ) ) then 
          xyz_Gamma(i,:,:) = xyz_Gamma(i,:,:) &
            & + ((1.0d0 - (XMax - x_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( p_X(i) > ( XMax - DampDepthH ) ) then 
          pyz_Gamma(i,:,:) = pyz_Gamma(i,:,:) &
            & + ((1.0d0 - (XMax - p_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if

    ! x ˤƱ
    !
    xyr_Gamma  = xyz_Gamma
    xqz_Gamma  = xyz_Gamma

    !ʿ¦¦
    !
    if ( DampDepthH < y_dy(1) ) then 
      if (myrank == 0) &
        & call MessageNotify( "W", "Damping_init", "DampDepthH is too thin. DelY is %f", d=(/x_dx(1)/))

    else if ( DampDepthH < y_dy(ny) ) then 
      if (myrank == 0) &
        & call MessageNotify( "W", "Damping_init", "DampDepthH is too thin. DelY is %f", d=(/y_dy(ny)/))
  
    else
      do j = jmin, jmax
        !顼ʻ¦
        if ( y_Y(j) < DampDepthH) then 
          xyz_Gamma(:,j,:) = xyz_Gamma(:,j,:) &
            & + ((1.0d0 - y_Y(j) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( q_Y(j) < DampDepthH) then 
          xqz_Gamma(:,j,:) = xqz_Gamma(:,j,:) &
            & + ((1.0d0 - q_Y(j) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( y_Y(j) > ( YMax - DampDepthH ) ) then 
          xyz_Gamma(:,j,:) = xyz_Gamma(:,j,:) &
            & + ((1.0d0 - (YMax - y_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( q_Y(j) > ( YMax - DampDepthH ) ) then 
          xqz_Gamma(:,j,:) = xqz_Gamma(:,j,:)  &
            & + ((1.0d0 - (YMax - q_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    
    ! y ˤƱ
    !
    pyz_Gamma  = xyz_Gamma
    xyr_Gamma  = xyz_Gamma

    
    !ľξ    
    !
    if ( DampDepthV < z_dz(nz) ) then 
      if (myrank == 0) &
        & call MessageNotify( "W", "Damping_init", "DampDepthV is too thin. DelZ is %f", d=(/z_dz(nz)/) )      

    else
      do k = kmin, kmax
        !顼ʻ
        if ( z_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyz_Gamma(:,:,k) = xyz_Gamma(:,:,k) &
            & + (1.0d0 - dcos(Pi * (z_Z(k) - ZMax + DampDepthV) / DampDepthV)) &
            &    / EFTime 
        end if
        
        !եåʻ
        if ( r_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyr_Gamma(:,:,k) = xyr_Gamma(:,:,k) &
            & + (1.0d0 - dcos(Pi * (r_Z(k) - ZMax + DampDepthV)/ DampDepthV)) &
            &    / EFTime 
        end if
      end do
    end if

    ! z ˤƱ
    !
    pyz_Gamma  = xyz_Gamma
    xqz_Gamma  = xyz_Gamma
    

    !-----------------------------------------------------------------    
    ! ͤγǧ
    !
    if (myrank == 0) then 
      call MessageNotify( "M", "Damping_init", "EFTime = %f", d=(/EFTime/) )
      call MessageNotify( "M", "Damping_init", "DampDepthH = %f", d=(/DampDepthH/) )
      call MessageNotify( "M", "Damping_init", "DampDepthV = %f", d=(/DampDepthV/) )  
    end if

    !-----------------------------------------------------------------    
    ! 
    !
    call HistoryAutoAddVariable(                          &
      & varname='PTempSpng',                              &
      & dims=(/'x','y','z','t'/),                         &
      & longname='Damping term of potential temperature', &
      & units='K.s-1',                                    &
      & xtype='float')

    call HistoryAutoAddVariable(                    &
      & varname='ExnerSpng',                        &
      & dims=(/'x','y','z','t'/),                   &
      & longname='Damping term of exner function',  &
      & units='s-1',                                &
      & xtype='float')

    call HistoryAutoAddVariable(          &
      & varname='VelXSpng',               &
      & dims=(/'x','y','z','t'/),         &
      & longname='Damping term of VelX',  &
      & units='m.s-1',                    &
      & xtype='float')

    call HistoryAutoAddVariable(          &
      & varname='VelYSpng',               &
      & dims=(/'x','y','z','t'/),         &
      & longname='Damping term of VelY',  &
      & units='m.s-1',                    &
      & xtype='float')

    call HistoryAutoAddVariable(          &
      & varname='VelZSpng',               &
      & dims=(/'x','y','z','t'/),         &
      & longname='Damping term of VelZ',  &
      & units='m.s-1',                    &
      & xtype='float')

  end subroutine Damping_Init


  subroutine SpongeLayer_forcing(                                         &
    & pyz_VelXBl,  xqz_VelYBl,  xyr_VelZBl,  xyz_PTempBl,  xyz_ExnerBl,   & !(in) 
    & pyz_DVelXDt, xqz_DVelYDt, xyr_DVelZDt, xyz_DPTempDt, xyz_DExnerDt )   !(inout)

    use gtool_historyauto, only: HistoryAutoPut
    use timeset, only: TimeN        ! ߤλ
    use gridset, only: imin,       &! x β
      &                imax,       &! x ξ
      &                jmin,       &! y β
      &                jmax,       &! y ξ
      &                kmin,       &! z β
      &                kmax,       &! z ξ
      &                nx,         &! x ʪΰξ
      &                ny,         &! y ʪΰξ
      &                nz           ! z ʪΰξ

    !ۤηػ
    implicit none

    real(8), intent(in)    :: pyz_VelXBl(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)    :: xqz_VelYBl(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)    :: xyr_VelZBl(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)    :: xyz_PTempBl(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)    :: xyz_ExnerBl(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(inout) :: pyz_DVelXDt(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(inout) :: xqz_DVelYDt(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(inout) :: xyr_DVelZDt(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(inout) :: xyz_DPTempDt(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(inout) :: xyz_DExnerDt(imin:imax, jmin:jmax, kmin:kmax)
    real(8)                :: pyz_SpngVelX(imin:imax, jmin:jmax, kmin:kmax)
    real(8)                :: xqz_SpngVelY(imin:imax, jmin:jmax, kmin:kmax)
    real(8)                :: xyr_SpngVelZ(imin:imax, jmin:jmax, kmin:kmax)
    real(8)                :: xyz_SpngPTemp(imin:imax, jmin:jmax, kmin:kmax)
    real(8)                :: xyz_SpngExner(imin:imax, jmin:jmax, kmin:kmax)

    !--------------------------------------------------------
    ! ͤ򥼥᤹褦ʶͿ 
    !
    pyz_SpngVelX  =  - pyz_Gamma * pyz_VelXBl
    xqz_SpngVelY  =  - xqz_Gamma * xqz_VelYBl
    xyr_SpngVelZ  =  - xyr_Gamma * xyr_VelZBl
    xyz_SpngPTemp =  - xyz_Gamma * xyz_PTempBl
    xyz_SpngExner =  - xyz_Gamma * xyz_ExnerBl

    pyz_DVelXDt  = pyz_DVelXDt  + pyz_SpngVelX
    xqz_DVelYDt  = xqz_DVelYDt  + xqz_SpngVelY
    xyr_DVelZDt  = xyr_DVelZDt  + xyr_SpngVelZ
    xyz_DPTempDt = xyz_DPTempDt + xyz_SpngPTemp
    xyz_DExnerDt = xyz_DExnerDt + xyz_SpngExner

    call HistoryAutoPut(TimeN, 'VelXSpng',  pyz_SpngVelX(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSpng',  xqz_SpngVelY(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZSpng',  xyr_SpngVelZ(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'PTempSpng', xyz_SpngPTemp(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerSpng', xyz_SpngExner(1:nx,1:ny,1:nz))

  end subroutine SpongeLayer_forcing

  
end module Damping
