!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 3  (xyz ) ֳָ߳ʻ ʬ黻⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2007/06/27 () : 1 ʬ黻⥸塼˰¸ʤ褦
!  * 2006/06/07 () : 
!

module xyz_deriv_c4_module
  != 3  (xyz ) ֳָ߳ʻ ʬ黻⥸塼
  !
  !== ǽ
  !
  ! xyz_deriv_module , 3  (xyz ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤ, ʬ黻Ԥ Fortran90 ؿ󶡤. 
  ! ʬ黻 4 濴ʬѤƹԤ.
  !
  ! Υ⥸塼ϲ⥸塼Ȥ xyz_base_module, data_type 
  ! ⥸塼ѤƤ. 
  !
  ! ⥸塼ѿȼ³̿̾ˡˤĤƤ xyz_module 򻲾ȤΤ.
  !
  !
  !== ѿ, ³
  !
  !=== 1 ʬ
  !
  ! xyz_dx_pyz, pyz_dx_xyz :: x  1 ʬ׻
  ! xyz_dy_xqz, xqz_dy_xyz :: y  1 ʬ׻
  ! xyz_dz_xyr, xyr_dz_xyz :: z  1 ʬ׻
  !
  !
  !== 
  !
  ! ʬϳʻҴֳ֤Ȥ
  !
  !    du/dx(i) = 9/8*[u(i)-u(i-1)]/dx(i) - 1/24*[u(i+1)-u(i-2)]/dx(i)
  ! 
  ! ѤƤ. ֳֳʻҤξ٤뤳Ȥ.
  !

  use dc_types,   only : DP
  use dc_message, only : MessageNotify
  use gridset,    only : imin, imax, jmin, jmax, kmin, kmax
  use axesset,    only : x_dx, p_dx, y_dy, q_dy, z_dz, r_dz       

  implicit none
  private
  public :: xyz_c4dx_pyz, pyz_c4dx_xyz, pyr_c4dx_xyr, pqz_c4dx_xqz, &
    &       xyz_c4dy_xqz, xqz_c4dy_xyz, pqz_c4dy_pyz, xqr_c4dy_xyr, &
    &       xyz_c4dz_xyr, xyr_c4dz_xyz, pyr_c4dz_pyz, xqr_c4dz_xqz

  interface pyz_c4dx_xyz
    module procedure paa_c4dx_xaa
  end interface

  interface pyr_c4dx_xyr
    module procedure paa_c4dx_xaa
  end interface

  interface pqz_c4dx_xqz
    module procedure paa_c4dx_xaa
  end interface
 
  interface xqz_c4dy_xyz
    module procedure aqa_c4dy_aya
  end interface

  interface pqz_c4dy_pyz
    module procedure aqa_c4dy_aya
  end interface

  interface xqr_c4dy_xyr
    module procedure aqa_c4dy_aya
  end interface

  interface xyr_c4dz_xyz
    module procedure aar_c4dz_aaz
  end interface

  interface pyr_c4dz_pyz
    module procedure aar_c4dz_aaz
  end interface

  interface xqr_c4dz_xqz
    module procedure aar_c4dz_aaz
  end interface


  contains
!--------------------------------------------------------------------
    function xyz_c4dx_pyz(pyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_c4dx_pyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix                          

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_c4dx_pyz = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin+2, imax-1
        xyz_c4dx_pyz(ix,:,:) = &
          &   ((pyz_Var(ix,:,:)   - pyz_Var(ix-1,:,:))*9.0d0/(8.0d0*x_dx(ix)) &
          & - ((pyz_Var(ix+1,:,:) - pyz_Var(ix-2,:,:))/(24.0d0*x_dx(ix))))
      end do

    end function xyz_c4dx_pyz
!--------------------------------------------------------------------
    function paa_c4dx_xaa(xaa_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: paa_c4dx_xaa(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix                          

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      paa_c4dx_xaa = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin+1, imax-2
        paa_c4dx_xaa(ix,:,:) = &
          &   ((xaa_Var(ix+1,:,:) - xaa_Var(ix,:,:))*9.0d0/(8.0d0*p_dx(ix)) &
          & - ((xaa_Var(ix+2,:,:) - xaa_Var(ix-1,:,:))/(24.0d0*p_dx(ix))))
      end do

    end function paa_c4dx_xaa
!--------------------------------------------------------------------
    function xyz_c4dy_xqz(xqz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_c4dy_xqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy                          

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_c4dy_xqz = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin+2, jmax-1
        xyz_c4dy_xqz(:,jy,:) = &
          &   ((xqz_Var(:,jy,:)   - xqz_Var(:,jy-1,:))*9.0d0/(8.0d0*y_dy(jy)) &
          & - ((xqz_Var(:,jy+1,:) - xqz_Var(:,jy-2,:))/(24.0d0*y_dy(jy))))
      end do

    end function xyz_c4dy_xqz
!--------------------------------------------------------------------
    function aqa_c4dy_aya(aya_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: aqa_c4dy_aya(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy                          

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aqa_c4dy_aya = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin+1, jmax-2
        aqa_c4dy_aya(:,jy,:) = &
          &   ((aya_Var(:,jy+1,:) - aya_Var(:,jy,:))*9.0d0/(8.0d0*q_dy(jy)) &
          & - ((aya_Var(:,jy+2,:) - aya_Var(:,jy-1,:))/(24.0d0*q_dy(jy))))
      end do

    end function aqa_c4dy_aya
!--------------------------------------------------------------------
    function xyz_c4dz_xyr(xyr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_c4dz_xyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_c4dz_xyr = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin+2, kmax-1
        xyz_c4dz_xyr(:,:,kz) = &
          &   ((xyr_Var(:,:,kz)   - xyr_Var(:,:,kz-1))*9.0d0/(8.0d0*z_dz(kz)) &
          & - ((xyr_Var(:,:,kz+1) - xyr_Var(:,:,kz-2))/(24.0d0*z_dz(kz))))
      end do

    end function xyz_c4dz_xyr
!--------------------------------------------------------------------
    function aar_c4dz_aaz(aaz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: aar_c4dz_aaz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aar_c4dz_aaz = 0.0d0

      ! 1 ʬη׻
      ! * r_c4dz_z ѤƷ׻
      !
      do kz = kmin+1, kmax-2
        aar_c4dz_aaz(:,:,kz) = &
          &   ((aaz_Var(:,:,kz+1) - aaz_Var(:,:,kz))*9.0d0/(8.0d0*r_dz(kz)) &
          & - ((aaz_Var(:,:,kz+2) - aaz_Var(:,:,kz-1))/(24.0d0*r_dz(kz))))
      end do

    end function aar_c4dz_aaz
!--------------------------------------------------------------------
end module xyz_deriv_c4_module
