!= Module Damping
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: damping.f90,v 1.5 2011-06-17 19:07:27 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ΨȤη׻ԤΥѥå⥸塼
!  * ȸη
!  * ݥؤ(նȤȿͤޤۼ뤿)
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * δؿ, ܾ줬ѿ(®, ʡؿξ)
!    ŬѤ뤳ȤꤷƤ. 
!  * ƳʻФؿɬפ
!
!== Future Plans
!
!

module Damping
  !
  !ΨȤη׻ԤΥѥå⥸塼
  !  * ȸη
  !  * ݥؤ(նȤȿͤޤۼ뤿)
  ! 

  !⥸塼ɤ߹
  use dc_types,   only : DP
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use timeset, only: DelTimeLong
  use gridset, only: imin,       &! x β
    &                imax,       &! x ξ
    &                jmin,       &! y β
    &                jmax,       &! y ξ
    &                kmin,       &! z β
    &                kmax,       &! z ξ
    &                nx,         &! x ʪΰξ
    &                ny,         &! y ʪΰξ
    &                nz           ! z ʪΰξ
  use axesset, only: x_X,        &!X ɸ(顼ʻ)
    &                y_Y,        &!Y ɸ(顼ʻ)
    &                z_Z,        &!Z ɸ(顼ʻ)
    &                p_X,        &!X ɸ(եåʻ)
    &                q_Y,        &!Y ɸ(եåʻ)
    &                r_Z,        &!Z ɸ(եåʻ)
    &                x_dx, y_dy, z_dz, &! ʻҴֳ
    &                XMax,          &!X ɸκ
    &                YMax,          &!Y ɸκ
    &                ZMax            !Z ɸκ 
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  !private °
  private 
  
  !ؿˤ public °
  public Damping_Init
  public xyz_DampSponge_xyz
  public xyr_DampSponge_xyr
  public pyz_DampSponge_pyz
  public xqz_DampSponge_xqz
  public xyz_DampSponge
  public xyr_DampSponge
  public pyz_DampSponge
  public xqz_DampSponge
  public DampSponge_xyz
  public DampSponge_xyr
  public DampSponge_pyz
  public DampSponge_xqz

  !ѿ
  real(DP), save :: EFTime     = 100.0d0 !ݥؤ e-folding time
  real(DP), save :: DampDepthH = 0.0d0   !ݥؤθ(ʿ)
  real(DP), save :: DampDepthV = 0.0d0   !ݥؤθ(ľ)
  real(DP), allocatable, save :: xyz_DampRateH(:,:,:) !xyz ʻҸ그(ʿ)
  real(DP), allocatable, save :: xyz_DampRateV(:,:,:) !xyz ʻҸ그(ľ)
  real(DP), allocatable, save :: pyz_DampRateH(:,:,:) !pyz ʻҸ그(ʿ)
  real(DP), allocatable, save :: pyz_DampRateV(:,:,:) !pyz ʻҸ그(ľ)
  real(DP), allocatable, save :: xqz_DampRateH(:,:,:) !xqz ʻҸ그(ʿ)
  real(DP), allocatable, save :: xqz_DampRateV(:,:,:) !xqz ʻҸ그(ľ)
  real(DP), allocatable, save :: xyr_DampRateH(:,:,:) !xyr ʻҸ그(ʿ)
  real(DP), allocatable, save :: xyr_DampRateV(:,:,:) !xyr ʻҸ그(ľ)

contains 
  
!!!------------------------------------------------------------------------!!!
  subroutine Damping_Init
    !
    ! ȸȥݥؤθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    real(DP)                  :: Time     !
    real(DP)                  :: DepthH   !ݥؤθ(ʿ)
    real(DP)                  :: DepthV   !ݥؤθ(ľ)
    real(DP), parameter       :: Pi =3.1415926535897932385d0   !߼Ψ
    integer                  :: unit ! ֹ
    integer                   :: i, j, k

    !NAMELIST 
    NAMELIST /damping_nml/ Time, DepthH, DepthV

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=damping_nml)
    close(unit)

    !
    allocate( &
      & xyz_DampRateH(imin:imax,jmin:jmax,kmin:kmax), &
      & xyz_DampRateV(imin:imax,jmin:jmax,kmin:kmax), &
      & pyz_DampRateH(imin:imax,jmin:jmax,kmin:kmax), &
      & pyz_DampRateV(imin:imax,jmin:jmax,kmin:kmax), &
      & xqz_DampRateH(imin:imax,jmin:jmax,kmin:kmax), &
      & xqz_DampRateV(imin:imax,jmin:jmax,kmin:kmax), &
      & xyr_DampRateH(imin:imax,jmin:jmax,kmin:kmax), &
      & xyr_DampRateV(imin:imax,jmin:jmax,kmin:kmax)    )
    xyz_DampRateH = 0.0d0
    xyz_DampRateV = 0.0d0
    pyz_DampRateH = 0.0d0
    pyz_DampRateV = 0.0d0
    xqz_DampRateH = 0.0d0
    xqz_DampRateV = 0.0d0
    xyr_DampRateH = 0.0d0
    xyr_DampRateV = 0.0d0

    !ͤ
    EFTime     = Time
    DampDepthH = DepthH
    DampDepthV = DepthV
    
    !-----------------------------------------------------------------    
    ! ݥؤθΨ
    !-----------------------------------------------------------------
    !ʿ¦¦
    if ( DampDepthH < x_dx(1) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(1)/))

    else if ( DampDepthH < x_dx(nx) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelX is %f", d=(/x_dx(nx)/))

    else
      do i = imin, imax
        !顼ʻ¦
        if ( x_X(i) < DampDepthH) then 
          xyz_DampRateH(i,:,:) = ((1.0d0 - x_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( p_X(i) < DampDepthH) then 
          pyz_DampRateH(i,:,:) = ((1.0d0 - p_X(i) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( x_X(i) > ( XMax - DampDepthH ) ) then 
          xyz_DampRateH(i,:,:) = &
            & ((1.0d0 - (XMax - x_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( p_X(i) > ( XMax - DampDepthH ) ) then 
          pyz_DampRateH(i,:,:) = &
            & ((1.0d0 - (XMax - p_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xyr_DampRateH  = xyz_DampRateH

    !ʿ¦¦
    if ( DampDepthH < y_dy(1) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelY is %f", d=(/x_dx(1)/))

    else if ( DampDepthH < y_dy(ny) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthH is too thin. DelY is %f", d=(/y_dy(ny)/))

    else
      do j = jmin, jmax
        !顼ʻ¦
        if ( y_Y(j) < DampDepthH) then 
          xyz_DampRateH(:,j,:) = ((1.0d0 - y_Y(j) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( q_Y(j) < DampDepthH) then 
          pyz_DampRateH(:,j,:) = ((1.0d0 - q_Y(j) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( y_Y(j) > ( YMax - DampDepthH ) ) then 
          xyz_DampRateH(:,j,:) = &
            & ((1.0d0 - (YMax - y_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( q_Y(j) > ( YMax - DampDepthH ) ) then 
          pyz_DampRateH(:,j,:) = &
            & ((1.0d0 - (YMax - q_Y(j)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xqz_DampRateH  = xyz_DampRateH

    
    !ľξ    
    if ( DampDepthV < z_dz(nz) ) then 
      call MessageNotify( "W", &
        & "DampSponge_Init", "DampDepthV is too thin. DelZ is %f", d=(/z_dz(nz)/) )
      
    else
      do k = kmin, kmax
        !顼ʻ
        if ( z_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyz_DampRateV(:,:,k) =  &
            & (1.0d0 - dcos(Pi * (z_Z(k) - ZMax + DampDepthV) / DampDepthV)) &
            &  / EFTime 
        end if
        
        !եåʻ
        if ( r_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xyr_DampRateV(:,:,k) =  &
            & (1.0d0 - dcos(Pi * (r_Z(k) - ZMax + DampDepthV)/ DampDepthV)) &
            &  / EFTime 
        end if
      end do
    end if
    !fs  ss  Z ˴ؤƤƱ
    pyz_DampRateV  = xyz_DampRateV
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------

    call MessageNotify( "M", "DampSponge_Init", "EFTime = %f", d=(/EFTime/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthH = %f", d=(/DampDepthH/) )
    call MessageNotify( "M", "DampSponge_Init", "DampDepthV = %f", d=(/DampDepthV/) )  

  end subroutine Damping_Init
!!!------------------------------------------------------------------------!!!
  function xyz_DampSponge_xyz(xyz_Var)
    !
    ! xyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_DampSponge_xyz(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻
    xyz_DampSponge_xyz =  ( xyz_DampRateH + xyz_DampRateV ) * xyz_Var
    
  end function xyz_DampSponge_xyz
!!!------------------------------------------------------------------------!!!
  function xyz_DampSponge(xyz_VarA, xyz_VarB)
    !
    ! xyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyz_VarA(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)   :: xyz_VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_DampSponge(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻
    xyz_DampSponge =  xyz_VarA - ( xyz_DampRateH + xyz_DampRateV ) * xyz_VarB * (2.0d0 * DelTimeLong)
    
  end function xyz_DampSponge


!!!------------------------------------------------------------------------!!!
  function xyr_DampSponge_xyr(xyr_Var)
    !
    ! xyr ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyr_DampSponge_xyr(imin:imax,jmin:jmax,kmin:kmax)

    !ݥؤˤԥ󥰤׻  
    xyr_DampSponge_xyr =  ( xyr_DampRateH + xyr_DampRateV )* xyr_Var
    
  end function xyr_DampSponge_xyr


!!!------------------------------------------------------------------------!!!
  function xyr_DampSponge(xyr_VarA, xyr_VarB)
    !
    ! xyr ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xyr_VarA(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)   :: xyr_VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyr_DampSponge(imin:imax,jmin:jmax,kmin:kmax)

    !ݥؤˤԥ󥰤׻  
    xyr_DampSponge =  xyr_VarA - ( xyr_DampRateH + xyr_DampRateV )* xyr_VarB * (2.0d0 * DelTimeLong)
    
  end function xyr_DampSponge


!!!------------------------------------------------------------------------!!!
  function pyz_DampSponge_pyz(pyz_Var)
    !
    ! pyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: pyz_DampSponge_pyz(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    pyz_DampSponge_pyz = ( pyz_DampRateH + pyz_DampRateV ) * pyz_Var
    
  end function pyz_DampSponge_pyz
  

!!!------------------------------------------------------------------------!!!
  function pyz_DampSponge(pyz_VarA, pyz_VarB)
    !
    ! pyz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: pyz_VarA(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)   :: pyz_VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: pyz_DampSponge(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    pyz_DampSponge = pyz_VarA - ( pyz_DampRateH + pyz_DampRateV ) * pyz_VarB * (2.0d0 * DelTimeLong)
    
  end function pyz_DampSponge
!!!------------------------------------------------------------------------!!!
  function xqz_DampSponge_xqz(xqz_Var)
    !
    ! xqz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xqz_DampSponge_xqz(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    xqz_DampSponge_xqz = ( xqz_DampRateH + xqz_DampRateV ) * xqz_Var
    
  end function xqz_DampSponge_xqz
!!!------------------------------------------------------------------------!!!
  function xqz_DampSponge(xqz_VarA, xqz_VarB)
    !
    ! xqz ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)   :: xqz_VarA(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)   :: xqz_VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xqz_DampSponge(imin:imax,jmin:jmax,kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    xqz_DampSponge = xqz_VarA - ( xqz_DampRateH + xqz_DampRateV ) * xqz_VarB * (2.0d0 * DelTimeLong)
    
  end function xqz_DampSponge

!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_xyz(xyz_VarA, xyz_VarB)
    !
    ! ss ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: xyz_VarA(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)   :: xyz_VarB(imin:imax, jmin:jmax, kmin:kmax)
    real(8)               :: xyz_Var(imin:imax, jmin:jmax, kmin:kmax)
    
    !ݥؤˤԥ󥰤׻
    xyz_Var  = xyz_VarA - ( xyz_DampRateH + xyz_DampRateV ) * xyz_VarB * (2.0d0 * DelTimeLong)
    xyz_VarA = xyz_Var
    
  end subroutine DampSponge_xyz


!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_xyr(xyr_VarA, xyr_VarB)
    !
    ! sf ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: xyr_VarA(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)   :: xyr_VarB(imin:imax, jmin:jmax, kmin:kmax)
    real(8)               :: xyr_Var(imin:imax, jmin:jmax, kmin:kmax)

    !ݥؤˤԥ󥰤׻  
    xyr_Var  = xyr_VarA - ( xyr_DampRateH + xyr_DampRateV )* xyr_VarB * (2.0d0 * DelTimeLong)
    xyr_VarA = xyr_Var
    
  end subroutine DampSponge_xyr
  

!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_pyz(pyz_VarA, pyz_VarB)
    !
    ! fs ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: pyz_VarA(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)   :: pyz_VarB(imin:imax, jmin:jmax, kmin:kmax)
    real(8)               :: pyz_Var(imin:imax, jmin:jmax, kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    pyz_Var  = pyz_VarA - ( pyz_DampRateH + pyz_DampRateV ) * pyz_VarB * (2.0d0 * DelTimeLong)
    pyz_VarA = pyz_Var
    
  end subroutine DampSponge_pyz
  
!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_xqz(xqz_VarA, xqz_VarB)
    !
    ! fs ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(inout):: xqz_VarA(imin:imax, jmin:jmax, kmin:kmax)
    real(8), intent(in)   :: xqz_VarB(imin:imax, jmin:jmax, kmin:kmax)
    real(8)               :: xqz_Var(imin:imax, jmin:jmax, kmin:kmax)
    
    !ݥؤˤԥ󥰤׻  
    xqz_Var  = xqz_VarA - ( xqz_DampRateH + xqz_DampRateV ) * xqz_VarB * (2.0d0 * DelTimeLong)
    xqz_VarA = xqz_Var
    
  end subroutine DampSponge_xqz
  
  
end module Damping
