!= Module TimeSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: timeset.f90,v 1.6 2011-06-18 14:25:41 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module timeset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types,   only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use mpi_wrapper, only: myrank
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none

  !°
  private
  
  ! Public Interface
  real(DP), save, public  :: TimeA                   ! t + \del t
  real(DP), save, public  :: TimeN                   ! t
  real(DP), save, public  :: TimeB                   ! t - \del t
  real(DP), save, public  :: DelTimeLong  = 2.0d0    !Ĺॹƥå
  real(DP), save, public  :: DelTimeLongSave  = 2.0d0 !Ĺॹƥå
  real(DP), save, public  :: DelTimeShort = 2.0d-1   !ûॹƥå
  real(DP), save, public  :: RestartTime  = 0.0d0    !׻ϻ
  real(DP), save, public  :: IntegPeriod  = 3600.0d0 !ʬ
  real(DP), save, public  :: EndTime      = 3600.0d0 !׻λ
  real(DP), save, public  :: DelTimeOutput= 2.0d0    !ϥॹƥå
  integer,  save, public  :: NstepShort = 20         !ûॹƥåפΥƥå׿
  integer,  save, public  :: NstepShortSave = 20     !ûॹƥåפΥƥå׿
  
  ! 
  public timeset_init, TimesetProgress

contains
   
  subroutine timeset_init()
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer    :: unit

    !---------------------------------------------------------------    
    ! NAMELIST 
    !
    NAMELIST /timeset_nml/ &
      & DelTimeLong, DelTimeShort, IntegPeriod, Restarttime, DelTimeOutput
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=timeset_nml)
    close(unit)

    !--------------------------------------------------------------- 
    ! λ
    !
    EndTime = RestartTime + IntegPeriod
    
    !---------------------------------------------------------------
    ! ॹƥåפ
    !   t=0 λ, ǽ 1 롼פ顼ˡǲ򤯤ΤǺٹ. 
    !    
    NstepShort = 2 * nint( DelTimeLong / DelTimeShort )

    DelTimeLongSave = DelTimeLong
    NstepShortSave  = NstepShort

    if (RestartTime /= 0.0d0) then 
      TimeB = RestartTime - DelTimeLong
      TimeN = RestartTime
      TimeA = RestartTime + DelTimeLong      
    else
      TimeB = RestartTime
      TimeN = RestartTime
      TimeA = RestartTime + DelTimeLong
      DelTimeLong = DelTimeLong * 5.0d-1
      NstepShort = NstepShort / 2
    end if

    !---------------------------------------------------------------
    ! ǧ
    !
    if (myrank == 0) then
    
      !ʬ֤Ĺ֥ƥåפǳڤʤˤϷٹФ
      if(mod((IntegPeriod - Restarttime), DelTimeLong) /= 0) then 
        call MessageNotify( "W", &
          & "timeset_init", "mod((IntegPeriod - Restarttime), DelTimeLong) is not zero")
      end if
      
      !Ĺ֥ƥåפû֥ƥåפǳڤʤˤϷٹФ
      if(mod(DelTimeLong, DelTimeShort) /= 0) then 
        call MessageNotify( "W", &
          & "timeset_init", "mod(DelTimeLong, DelTimeShort) is not zero")
      end if
      
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeLong  = %f", d=(/DelTimeLongSave/) )
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeShort = %f", d=(/DelTimeShort/) )
      call MessageNotify( "M", &
        & "timeset_init", "Restarttime = %f",  d=(/Restarttime/)  )
      call MessageNotify( "M", &
        & "timeset_init", "IntegPeriod = %f", d=(/IntegPeriod/) )
      call MessageNotify( "M", &
        & "timeset_init", "EndTime     = %f", d=(/EndTime/) )
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeOutput= %f", d=(/DelTimeOutput/) )
    end if
   
  end subroutine timeset_init


  subroutine TimesetProgress

    implicit none

    ! ľ 
    !
    DelTimeLong = DelTimeLongSave
    NstepShort  = NstepShortSave

    ! ʤ
    !
    TimeB = TimeN
    TimeN = TimeA
    TimeA = TimeA + DelTimeLong

  end subroutine TimesetProgress
  
end module timeset
